/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.com.docmosis.operator;

import java.math.BigDecimal;
import net.sourceforge.jeval.com.docmosis.ExtendedBigDecimal;
import net.sourceforge.jeval.com.docmosis.function.FunctionHelper;
import net.sourceforge.jeval.com.docmosis.operator.AbstractOperator;

public class SubtractionOperator
extends AbstractOperator {
    public SubtractionOperator() {
        this("-");
    }

    protected SubtractionOperator(String string) {
        super(string, 5, true);
    }

    @Override
    public ExtendedBigDecimal evaluate(ExtendedBigDecimal extendedBigDecimal, ExtendedBigDecimal extendedBigDecimal2) {
        if (extendedBigDecimal.isNaN() || extendedBigDecimal2.isNaN()) {
            return ExtendedBigDecimal.NAN;
        }
        if (extendedBigDecimal.isInfinity() || extendedBigDecimal2.isInfinity()) {
            Double d = this.deriveInfiniteDouble(extendedBigDecimal);
            Double d2 = this.deriveInfiniteDouble(extendedBigDecimal2);
            Double d3 = d - d2;
            return this.deriveInfiniteExtendedBigDecimal(d3);
        }
        BigDecimal bigDecimal = extendedBigDecimal.getBigDecimal().subtract(extendedBigDecimal2.getBigDecimal(), FunctionHelper.getDefaultMathContext());
        return new ExtendedBigDecimal(bigDecimal);
    }

    @Override
    public ExtendedBigDecimal evaluate(ExtendedBigDecimal extendedBigDecimal) {
        return new ExtendedBigDecimal(extendedBigDecimal.getBigDecimal().negate(FunctionHelper.getDefaultMathContext()));
    }

    @Override
    public boolean isBoolean() {
        return false;
    }
}

