/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.com.docmosis.operator;

import java.math.BigDecimal;
import net.sourceforge.jeval.com.docmosis.ExtendedBigDecimal;
import net.sourceforge.jeval.com.docmosis.function.FunctionHelper;
import net.sourceforge.jeval.com.docmosis.operator.AbstractOperator;

public class MultiplicationOperator
extends AbstractOperator {
    public MultiplicationOperator() {
        super("*", 6);
    }

    @Override
    public ExtendedBigDecimal evaluate(ExtendedBigDecimal extendedBigDecimal, ExtendedBigDecimal extendedBigDecimal2) {
        if (extendedBigDecimal.isNaN() || extendedBigDecimal2.isNaN()) {
            return ExtendedBigDecimal.NAN;
        }
        if (extendedBigDecimal.isInfinity() || extendedBigDecimal2.isInfinity()) {
            boolean bl = this.isNegative(extendedBigDecimal);
            boolean bl2 = this.isNegative(extendedBigDecimal2);
            boolean bl3 = false;
            boolean bl4 = false;
            if (extendedBigDecimal.getBigDecimal() != null) {
                boolean bl5 = bl3 = BigDecimal.ZERO.compareTo(extendedBigDecimal.getBigDecimal()) == 0;
            }
            if (extendedBigDecimal2.getBigDecimal() != null) {
                boolean bl6 = bl4 = BigDecimal.ZERO.compareTo(extendedBigDecimal2.getBigDecimal()) == 0;
            }
            if (bl3 || bl4) {
                return ExtendedBigDecimal.NAN;
            }
            if (bl && bl2) {
                return ExtendedBigDecimal.POSITIVE_INFINITY;
            }
            if (bl || bl2) {
                return ExtendedBigDecimal.NEGATIVE_INFINITY;
            }
            return ExtendedBigDecimal.POSITIVE_INFINITY;
        }
        BigDecimal bigDecimal = extendedBigDecimal.getBigDecimal().multiply(extendedBigDecimal2.getBigDecimal(), FunctionHelper.getDefaultMathContext());
        return new ExtendedBigDecimal(bigDecimal);
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    private boolean isNegative(ExtendedBigDecimal extendedBigDecimal) {
        if (extendedBigDecimal.isInfinity()) {
            return extendedBigDecimal.isNegativeInfinity();
        }
        return extendedBigDecimal.getBigDecimal().compareTo(BigDecimal.ZERO) < 0;
    }
}

