/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.com.docmosis.operator;

import java.math.BigDecimal;
import net.sourceforge.jeval.com.docmosis.ExtendedBigDecimal;
import net.sourceforge.jeval.com.docmosis.function.FunctionHelper;
import net.sourceforge.jeval.com.docmosis.operator.AbstractOperator;

public class DivisionOperator
extends AbstractOperator {
    public DivisionOperator() {
        super("/", 6);
    }

    @Override
    public ExtendedBigDecimal evaluate(ExtendedBigDecimal extendedBigDecimal, ExtendedBigDecimal extendedBigDecimal2) {
        if (extendedBigDecimal.isNaN() || extendedBigDecimal2.isNaN()) {
            return ExtendedBigDecimal.NAN;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (extendedBigDecimal.getBigDecimal() != null) {
            boolean bl3 = bl = BigDecimal.ZERO.compareTo(extendedBigDecimal.getBigDecimal()) == 0;
        }
        if (extendedBigDecimal2.getBigDecimal() != null) {
            boolean bl4 = bl2 = BigDecimal.ZERO.compareTo(extendedBigDecimal2.getBigDecimal()) == 0;
        }
        if (bl && bl2) {
            return ExtendedBigDecimal.NAN;
        }
        if (bl) {
            return ExtendedBigDecimal.ZERO;
        }
        if (bl2) {
            if (extendedBigDecimal.isNegativeInfinity() || extendedBigDecimal.getBigDecimal() != null && extendedBigDecimal.getBigDecimal().compareTo(BigDecimal.ZERO) < 0) {
                return ExtendedBigDecimal.NEGATIVE_INFINITY;
            }
            return ExtendedBigDecimal.POSITIVE_INFINITY;
        }
        if (extendedBigDecimal.isInfinity() || extendedBigDecimal2.isInfinity()) {
            if (extendedBigDecimal.isInfinity() && extendedBigDecimal2.isInfinity()) {
                return ExtendedBigDecimal.NAN;
            }
            if (extendedBigDecimal2.isInfinity()) {
                return ExtendedBigDecimal.ZERO;
            }
            if (extendedBigDecimal.isPositiveInfinity()) {
                if (extendedBigDecimal2.getBigDecimal().compareTo(BigDecimal.ZERO) < 0) {
                    return ExtendedBigDecimal.NEGATIVE_INFINITY;
                }
                return ExtendedBigDecimal.POSITIVE_INFINITY;
            }
            if (extendedBigDecimal2.getBigDecimal().compareTo(BigDecimal.ZERO) < 0) {
                return ExtendedBigDecimal.POSITIVE_INFINITY;
            }
            return ExtendedBigDecimal.NEGATIVE_INFINITY;
        }
        BigDecimal bigDecimal = extendedBigDecimal.getBigDecimal().divide(extendedBigDecimal2.getBigDecimal(), FunctionHelper.getDefaultMathContext());
        return new ExtendedBigDecimal(bigDecimal);
    }

    @Override
    public boolean isBoolean() {
        return false;
    }
}

