/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.com.docmosis.operator;

import java.math.BigDecimal;
import net.sourceforge.jeval.com.docmosis.EvaluationException;
import net.sourceforge.jeval.com.docmosis.ExtendedBigDecimal;
import net.sourceforge.jeval.com.docmosis.operator.AbstractOperator;

public class BooleanOrOperator
extends AbstractOperator {
    public BooleanOrOperator() {
        this("||");
    }

    protected BooleanOrOperator(String string) {
        super(string, 1);
    }

    @Override
    public ExtendedBigDecimal evaluate(ExtendedBigDecimal extendedBigDecimal, ExtendedBigDecimal extendedBigDecimal2) {
        ExtendedBigDecimal extendedBigDecimal3 = this.evalInfiniteNAN(extendedBigDecimal, extendedBigDecimal2);
        if (extendedBigDecimal3 != null) {
            return extendedBigDecimal3;
        }
        extendedBigDecimal3 = this.evalInfiniteNAN(extendedBigDecimal2, extendedBigDecimal);
        if (extendedBigDecimal3 != null) {
            return extendedBigDecimal3;
        }
        if (BigDecimal.ONE.compareTo(extendedBigDecimal.getBigDecimal()) == 0 || BigDecimal.ONE.compareTo(extendedBigDecimal2.getBigDecimal()) == 0) {
            return ExtendedBigDecimal.ONE;
        }
        return ExtendedBigDecimal.ZERO;
    }

    @Override
    public String evaluate(String string, String string2) throws EvaluationException {
        string = this.stripQuotes(string);
        string2 = this.stripQuotes(string2);
        return "true".equals(string) || "1.0".equals(string) || "true".equals(string2) || "1.0".equals(string2) ? "1.0" : "0.0";
    }

    private ExtendedBigDecimal evalInfiniteNAN(ExtendedBigDecimal extendedBigDecimal, ExtendedBigDecimal extendedBigDecimal2) {
        if (extendedBigDecimal.isNaN() || extendedBigDecimal.isInfinity()) {
            if (extendedBigDecimal2.isNaN() || extendedBigDecimal2.isInfinity()) {
                return ExtendedBigDecimal.ZERO;
            }
            if (BigDecimal.ONE.compareTo(extendedBigDecimal2.getBigDecimal()) == 0) {
                return ExtendedBigDecimal.ONE;
            }
            return ExtendedBigDecimal.ZERO;
        }
        return null;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }
}

