/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.com.docmosis.operator;

import java.math.BigDecimal;
import net.sourceforge.jeval.com.docmosis.EvaluationException;
import net.sourceforge.jeval.com.docmosis.ExtendedBigDecimal;
import net.sourceforge.jeval.com.docmosis.operator.AbstractOperator;

public class BooleanAndOperator
extends AbstractOperator {
    public BooleanAndOperator() {
        this("&&");
    }

    protected BooleanAndOperator(String string) {
        super(string, 2);
    }

    @Override
    public ExtendedBigDecimal evaluate(ExtendedBigDecimal extendedBigDecimal, ExtendedBigDecimal extendedBigDecimal2) {
        if (extendedBigDecimal.isNaN() || extendedBigDecimal2.isNaN() || extendedBigDecimal.isInfinity() || extendedBigDecimal2.isInfinity()) {
            return ExtendedBigDecimal.ZERO;
        }
        if (BigDecimal.ONE.compareTo(extendedBigDecimal.getBigDecimal()) == 0 && BigDecimal.ONE.compareTo(extendedBigDecimal2.getBigDecimal()) == 0) {
            return ExtendedBigDecimal.ONE;
        }
        return ExtendedBigDecimal.ZERO;
    }

    @Override
    public String evaluate(String string, String string2) throws EvaluationException {
        string = this.stripQuotes(string);
        string2 = this.stripQuotes(string2);
        return !(!"true".equals(string) && !"1.0".equals(string) || !"true".equals(string2) && !"1.0".equals(string2)) ? "1.0" : "0.0";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }
}

