/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.com.docmosis.operator;

import java.math.BigDecimal;
import net.sourceforge.jeval.com.docmosis.ExtendedBigDecimal;
import net.sourceforge.jeval.com.docmosis.function.FunctionHelper;
import net.sourceforge.jeval.com.docmosis.operator.AbstractOperator;

public class AdditionOperator
extends AbstractOperator {
    public AdditionOperator() {
        super("+", 5, true);
    }

    @Override
    public ExtendedBigDecimal evaluate(ExtendedBigDecimal extendedBigDecimal, ExtendedBigDecimal extendedBigDecimal2) {
        if (extendedBigDecimal.isNaN() || extendedBigDecimal2.isNaN()) {
            return ExtendedBigDecimal.NAN;
        }
        if (extendedBigDecimal.isInfinity() || extendedBigDecimal2.isInfinity()) {
            Double d = this.deriveInfiniteDouble(extendedBigDecimal);
            Double d2 = this.deriveInfiniteDouble(extendedBigDecimal2);
            Double d3 = d + d2;
            return this.deriveInfiniteExtendedBigDecimal(d3);
        }
        BigDecimal bigDecimal = extendedBigDecimal.getBigDecimal().add(extendedBigDecimal2.getBigDecimal(), FunctionHelper.getDefaultMathContext());
        return new ExtendedBigDecimal(bigDecimal);
    }

    @Override
    public String evaluate(String string, String string2) {
        if (string == null) {
            string = "null";
        }
        if (string2 == null) {
            string2 = "null";
        }
        String string3 = new String(string.substring(0, string.length() - 1) + string2.substring(1, string2.length()));
        return string3;
    }

    @Override
    public ExtendedBigDecimal evaluate(ExtendedBigDecimal extendedBigDecimal) {
        return extendedBigDecimal;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }
}

