/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.com.docmosis.operator;

import java.math.BigDecimal;
import net.sourceforge.jeval.com.docmosis.EvaluationException;
import net.sourceforge.jeval.com.docmosis.Evaluator;
import net.sourceforge.jeval.com.docmosis.ExtendedBigDecimal;
import net.sourceforge.jeval.com.docmosis.function.FunctionHelper;
import net.sourceforge.jeval.com.docmosis.operator.Operator;

public abstract class AbstractOperator
implements Operator {
    private String C = null;
    private int A = 0;
    private boolean B = false;
    protected Evaluator evaluator;

    public AbstractOperator(String string, int n) {
        this.C = string;
        this.A = n;
    }

    public AbstractOperator(String string, int n, boolean bl) {
        this.C = string;
        this.A = n;
        this.B = bl;
    }

    @Override
    public ExtendedBigDecimal evaluate(ExtendedBigDecimal extendedBigDecimal, ExtendedBigDecimal extendedBigDecimal2) throws EvaluationException {
        if (this.B) {
            throw new EvaluationException("Attempt to call unary operator in binary fashion");
        }
        return ExtendedBigDecimal.ZERO;
    }

    @Override
    public String evaluate(String string, String string2) throws EvaluationException {
        throw new EvaluationException("Invalid operation for a string.");
    }

    @Override
    public ExtendedBigDecimal evaluate(ExtendedBigDecimal extendedBigDecimal) throws EvaluationException {
        if (!this.B) {
            throw new EvaluationException("Attempt to call binary operator in unary fashion");
        }
        return ExtendedBigDecimal.ZERO;
    }

    @Override
    public String getSymbol() {
        return this.C;
    }

    @Override
    public int getPrecedence() {
        return this.A;
    }

    @Override
    public int getLength() {
        return this.C.length();
    }

    @Override
    public boolean isUnary() {
        return this.B;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof AbstractOperator)) {
            throw new IllegalStateException("Invalid operator object.");
        }
        AbstractOperator abstractOperator = (AbstractOperator)object;
        return this.C.equals(abstractOperator.getSymbol());
    }

    public String toString() {
        return this.getSymbol();
    }

    @Override
    public void setEvaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    protected String stripQuotes(String string) {
        return this.evaluator.stripQuotes(string);
    }

    protected Double deriveInfiniteDouble(ExtendedBigDecimal extendedBigDecimal) {
        if (extendedBigDecimal.isNaN()) {
            return Double.NaN;
        }
        if (extendedBigDecimal.isNegativeInfinity()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (extendedBigDecimal.isPositiveInfinity()) {
            return Double.POSITIVE_INFINITY;
        }
        BigDecimal bigDecimal = extendedBigDecimal.getBigDecimal();
        if (BigDecimal.ZERO.compareTo(bigDecimal) == 0) {
            return 0.0;
        }
        if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
            return -10.0;
        }
        return 10.0;
    }

    protected ExtendedBigDecimal deriveInfiniteExtendedBigDecimal(Double d) {
        if (d.isNaN()) {
            return ExtendedBigDecimal.NAN;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return ExtendedBigDecimal.NEGATIVE_INFINITY;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return ExtendedBigDecimal.POSITIVE_INFINITY;
        }
        return new ExtendedBigDecimal(new BigDecimal(d, FunctionHelper.getDefaultMathContext()));
    }
}

