/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.com.docmosis.function.string;

import com.docmosis.util.StringUtilities;
import java.util.ArrayList;
import net.sourceforge.jeval.com.docmosis.Evaluator;
import net.sourceforge.jeval.com.docmosis.function.Function;
import net.sourceforge.jeval.com.docmosis.function.FunctionException;
import net.sourceforge.jeval.com.docmosis.function.FunctionHelper;
import net.sourceforge.jeval.com.docmosis.function.FunctionResult;

public class Substring
implements Function {
    @Override
    public String getName() {
        return "substring";
    }

    @Override
    public FunctionResult execute(Evaluator evaluator, String[] stringArray) throws FunctionException {
        String string = null;
        String string2 = "One string argument and two integer arguments are required.";
        ArrayList arrayList = FunctionHelper.getOneStringAndTwoIntegers(stringArray, ',');
        if (arrayList.size() != 3) {
            throw new FunctionException(string2);
        }
        String string3 = (String)arrayList.get(0);
        if (string3 != null && !"null".equals(string3)) {
            try {
                String string4 = FunctionHelper.trimAndRemoveQuoteChars(string3, evaluator.getQuoteCharacter(), false);
                if (StringUtilities.isEmpty(string4) || "null".equals(string4)) {
                    string = "";
                } else {
                    int n = (Integer)arrayList.get(1);
                    if (n >= string4.length()) {
                        string = "";
                    } else {
                        int n2 = Math.min(string4.length(), (Integer)arrayList.get(2));
                        string = string4.substring(n, n2);
                    }
                }
            }
            catch (FunctionException functionException) {
                throw new FunctionException(functionException.getMessage(), functionException);
            }
            catch (Exception exception) {
                throw new FunctionException(exception.getMessage(), exception);
            }
        }
        return new FunctionResult(string);
    }
}

