/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.com.docmosis.function.string;

import com.docmosis.util.StringUtilities;
import net.sourceforge.jeval.com.docmosis.Evaluator;
import net.sourceforge.jeval.com.docmosis.ExtendedBigDecimal;
import net.sourceforge.jeval.com.docmosis.function.Function;
import net.sourceforge.jeval.com.docmosis.function.FunctionException;
import net.sourceforge.jeval.com.docmosis.function.FunctionHelper;
import net.sourceforge.jeval.com.docmosis.function.FunctionResult;

public class Length
implements Function {
    @Override
    public String getName() {
        return "length";
    }

    @Override
    public FunctionResult execute(Evaluator evaluator, String[] stringArray) throws FunctionException {
        Double d = null;
        String string = "One string argument is required.";
        try {
            if (stringArray == null || stringArray.length != 1) {
                throw new FunctionException(string);
            }
            String string2 = stringArray[0];
            if (StringUtilities.isEmpty(string2) || "null".equals(string2)) {
                d = 0.0;
            } else {
                String string3 = FunctionHelper.trimAndRemoveQuoteChars(string2, evaluator.getQuoteCharacter());
                d = string3.length();
            }
        }
        catch (FunctionException functionException) {
            throw new FunctionException(functionException.getMessage(), functionException);
        }
        catch (Exception exception) {
            throw new FunctionException(string, exception);
        }
        return new FunctionResult(ExtendedBigDecimal.valueOf(d));
    }
}

