/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.com.docmosis.function.math;

import ch.obermuhlner.math.big.docmosis.BigDecimalMath;
import java.math.BigDecimal;
import net.sourceforge.jeval.com.docmosis.Evaluator;
import net.sourceforge.jeval.com.docmosis.ExtendedBigDecimal;
import net.sourceforge.jeval.com.docmosis.function.Function;
import net.sourceforge.jeval.com.docmosis.function.FunctionException;
import net.sourceforge.jeval.com.docmosis.function.FunctionHelper;
import net.sourceforge.jeval.com.docmosis.function.FunctionResult;

public class Sqrt
implements Function {
    @Override
    public String getName() {
        return "sqrt";
    }

    @Override
    public FunctionResult execute(Evaluator evaluator, String[] stringArray) throws FunctionException {
        ExtendedBigDecimal extendedBigDecimal = null;
        ExtendedBigDecimal extendedBigDecimal2 = null;
        try {
            extendedBigDecimal2 = ExtendedBigDecimal.valueOf(FunctionHelper.trimAndRemoveQuoteChars(stringArray[0], evaluator.getQuoteCharacter(), false));
        }
        catch (Exception exception) {
            throw new FunctionException("Invalid argument.", exception);
        }
        if (extendedBigDecimal2.isPositiveInfinity()) {
            return new FunctionResult(ExtendedBigDecimal.POSITIVE_INFINITY);
        }
        if (extendedBigDecimal2.isNaN() || extendedBigDecimal2.isNegativeInfinity() || extendedBigDecimal2.getBigDecimal().compareTo(BigDecimal.ZERO) < 0) {
            return new FunctionResult(ExtendedBigDecimal.NAN);
        }
        extendedBigDecimal = new ExtendedBigDecimal(BigDecimalMath.sqrt(extendedBigDecimal2.getBigDecimal(), FunctionHelper.getDefaultMathContext()));
        return new FunctionResult(extendedBigDecimal);
    }
}

