/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.com.docmosis.function.math;

import java.math.RoundingMode;
import net.sourceforge.jeval.com.docmosis.Evaluator;
import net.sourceforge.jeval.com.docmosis.ExtendedBigDecimal;
import net.sourceforge.jeval.com.docmosis.function.Function;
import net.sourceforge.jeval.com.docmosis.function.FunctionException;
import net.sourceforge.jeval.com.docmosis.function.FunctionHelper;
import net.sourceforge.jeval.com.docmosis.function.FunctionResult;

public class Rint
implements Function {
    @Override
    public String getName() {
        return "rint";
    }

    @Override
    public FunctionResult execute(Evaluator evaluator, String[] stringArray) throws FunctionException {
        ExtendedBigDecimal extendedBigDecimal = null;
        ExtendedBigDecimal extendedBigDecimal2 = null;
        try {
            extendedBigDecimal2 = ExtendedBigDecimal.valueOf(FunctionHelper.trimAndRemoveQuoteChars(stringArray[0], evaluator.getQuoteCharacter(), false));
        }
        catch (Exception exception) {
            throw new FunctionException("Invalid argument.", exception);
        }
        if (extendedBigDecimal2.isNaN() || extendedBigDecimal2.isInfinity()) {
            return new FunctionResult(extendedBigDecimal2);
        }
        extendedBigDecimal = new ExtendedBigDecimal(extendedBigDecimal2.getBigDecimal().setScale(0, RoundingMode.HALF_EVEN));
        extendedBigDecimal = new ExtendedBigDecimal(extendedBigDecimal.getBigDecimal().setScale(1, RoundingMode.UNNECESSARY));
        return new FunctionResult(extendedBigDecimal);
    }
}

