/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.com.docmosis.function.math;

import ch.obermuhlner.math.big.docmosis.BigDecimalMath;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import net.sourceforge.jeval.com.docmosis.Evaluator;
import net.sourceforge.jeval.com.docmosis.ExtendedBigDecimal;
import net.sourceforge.jeval.com.docmosis.function.Function;
import net.sourceforge.jeval.com.docmosis.function.FunctionException;
import net.sourceforge.jeval.com.docmosis.function.FunctionHelper;
import net.sourceforge.jeval.com.docmosis.function.FunctionResult;
import net.sourceforge.jeval.com.docmosis.function.math.Abs;

public class Pow
implements Function {
    @Override
    public String getName() {
        return "pow";
    }

    @Override
    public FunctionResult execute(Evaluator evaluator, String[] stringArray) throws FunctionException {
        ExtendedBigDecimal extendedBigDecimal = null;
        ArrayList<ExtendedBigDecimal> arrayList = FunctionHelper.getExtendedBigDecimal(stringArray, ',');
        if (arrayList.size() != 2) {
            throw new FunctionException("Two numeric arguments are required.");
        }
        ExtendedBigDecimal extendedBigDecimal2 = arrayList.get(0);
        ExtendedBigDecimal extendedBigDecimal3 = arrayList.get(1);
        boolean bl = false;
        BigDecimal bigDecimal = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (extendedBigDecimal2.getBigDecimal() != null) {
            bl = BigDecimal.ZERO.compareTo(extendedBigDecimal2.getBigDecimal()) == 0;
            bigDecimal = Abs.abs(extendedBigDecimal2).getBigDecimal();
        }
        if (extendedBigDecimal3.getBigDecimal() != null) {
            bl2 = BigDecimal.ZERO.compareTo(extendedBigDecimal3.getBigDecimal()) == 0;
            boolean bl4 = bl3 = BigDecimal.ONE.compareTo(extendedBigDecimal3.getBigDecimal()) == 0;
        }
        if (extendedBigDecimal2.isInfinity() && extendedBigDecimal3.isInfinity()) {
            if (extendedBigDecimal3.isPositiveInfinity()) {
                return new FunctionResult(ExtendedBigDecimal.POSITIVE_INFINITY);
            }
            if (extendedBigDecimal3.isNegativeInfinity()) {
                return new FunctionResult(ExtendedBigDecimal.ZERO);
            }
        }
        if (bl2) {
            return new FunctionResult(ExtendedBigDecimal.ONE);
        }
        if (bl3) {
            return new FunctionResult(extendedBigDecimal2);
        }
        if (extendedBigDecimal3.isNaN()) {
            return new FunctionResult(ExtendedBigDecimal.NAN);
        }
        if (extendedBigDecimal2.isNaN() && !bl2) {
            return new FunctionResult(ExtendedBigDecimal.NAN);
        }
        if (bigDecimal != null && extendedBigDecimal3.isInfinity()) {
            if (bigDecimal.compareTo(BigDecimal.ONE) > 0 && extendedBigDecimal3.isPositiveInfinity() || bigDecimal.compareTo(BigDecimal.ONE) < 0 && extendedBigDecimal3.isNegativeInfinity()) {
                return new FunctionResult(ExtendedBigDecimal.POSITIVE_INFINITY);
            }
            if (bigDecimal.compareTo(BigDecimal.ONE) > 0 && extendedBigDecimal3.isNegativeInfinity() || bigDecimal.compareTo(BigDecimal.ONE) < 0 && extendedBigDecimal3.isPositiveInfinity()) {
                return new FunctionResult(ExtendedBigDecimal.ZERO);
            }
            if (bigDecimal.compareTo(BigDecimal.ONE) == 0) {
                return new FunctionResult(ExtendedBigDecimal.NAN);
            }
        }
        if (extendedBigDecimal3.getBigDecimal() != null) {
            boolean bl5 = extendedBigDecimal3.getBigDecimal().compareTo(BigDecimal.ZERO) > 0;
            boolean bl6 = extendedBigDecimal3.getBigDecimal().compareTo(BigDecimal.ZERO) < 0;
            boolean bl7 = this.isEven(extendedBigDecimal3.getBigDecimal());
            boolean bl8 = this.isOdd(extendedBigDecimal3.getBigDecimal());
            if (bl && bl8 && bl6 || extendedBigDecimal2.isNegativeInfinity() && bl8 && bl5) {
                return new FunctionResult(ExtendedBigDecimal.NEGATIVE_INFINITY);
            }
            if (bl && !bl8 && bl6 || extendedBigDecimal2.isNegativeInfinity() && !bl8 && bl5) {
                return new FunctionResult(ExtendedBigDecimal.POSITIVE_INFINITY);
            }
            if (bl && bl6 || extendedBigDecimal2.isPositiveInfinity() && bl5) {
                return new FunctionResult(ExtendedBigDecimal.POSITIVE_INFINITY);
            }
            if (bl && bl5 || extendedBigDecimal2.isInfinity() && bl6) {
                return new FunctionResult(ExtendedBigDecimal.ZERO);
            }
            if (extendedBigDecimal2.getBigDecimal() != null && extendedBigDecimal2.getBigDecimal().compareTo(BigDecimal.ZERO) < 0 && !bl7 && !bl8) {
                return new FunctionResult(ExtendedBigDecimal.NAN);
            }
        }
        try {
            extendedBigDecimal = new ExtendedBigDecimal(BigDecimalMath.pow(extendedBigDecimal2.getBigDecimal(), extendedBigDecimal3.getBigDecimal(), FunctionHelper.getDefaultMathContext()));
        }
        catch (ArithmeticException arithmeticException) {
            return new FunctionResult(ExtendedBigDecimal.POSITIVE_INFINITY);
        }
        catch (Exception exception) {
            throw new FunctionException("Two numeric arguments are required.", exception);
        }
        return new FunctionResult(extendedBigDecimal);
    }

    private boolean isEven(BigDecimal bigDecimal) {
        if (!this.isIntegerValue(bigDecimal)) {
            return false;
        }
        BigInteger bigInteger = bigDecimal.stripTrailingZeros().unscaledValue();
        boolean bl = !bigInteger.testBit(0);
        return bl;
    }

    private boolean isOdd(BigDecimal bigDecimal) {
        if (!this.isIntegerValue(bigDecimal)) {
            return false;
        }
        return !this.isEven(bigDecimal);
    }

    private boolean isIntegerValue(BigDecimal bigDecimal) {
        return bigDecimal.signum() == 0 || bigDecimal.scale() <= 0 || bigDecimal.stripTrailingZeros().scale() <= 0;
    }
}

