/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.com.docmosis.function.math;

import java.util.ArrayList;
import net.sourceforge.jeval.com.docmosis.Evaluator;
import net.sourceforge.jeval.com.docmosis.ExtendedBigDecimal;
import net.sourceforge.jeval.com.docmosis.function.Function;
import net.sourceforge.jeval.com.docmosis.function.FunctionException;
import net.sourceforge.jeval.com.docmosis.function.FunctionHelper;
import net.sourceforge.jeval.com.docmosis.function.FunctionResult;

public class Min
implements Function {
    @Override
    public String getName() {
        return "min";
    }

    @Override
    public FunctionResult execute(Evaluator evaluator, String[] stringArray) throws FunctionException {
        ExtendedBigDecimal extendedBigDecimal = null;
        ArrayList<ExtendedBigDecimal> arrayList = FunctionHelper.getExtendedBigDecimal(stringArray, ',');
        if (arrayList.size() != 2) {
            throw new FunctionException("Two numeric arguments are required.");
        }
        ExtendedBigDecimal extendedBigDecimal2 = arrayList.get(0);
        ExtendedBigDecimal extendedBigDecimal3 = arrayList.get(1);
        if (extendedBigDecimal2.isNaN() || extendedBigDecimal3.isNaN()) {
            extendedBigDecimal = ExtendedBigDecimal.NAN;
        } else if (extendedBigDecimal2.isInfinity() || extendedBigDecimal3.isInfinity()) {
            extendedBigDecimal = extendedBigDecimal2.isNegativeInfinity() || extendedBigDecimal3.isNegativeInfinity() ? ExtendedBigDecimal.NEGATIVE_INFINITY : (extendedBigDecimal2.isPositiveInfinity() && extendedBigDecimal3.isPositiveInfinity() ? ExtendedBigDecimal.POSITIVE_INFINITY : (!extendedBigDecimal2.isInfinity() ? extendedBigDecimal2 : extendedBigDecimal3));
        } else {
            try {
                extendedBigDecimal = new ExtendedBigDecimal(extendedBigDecimal2.getBigDecimal().min(extendedBigDecimal3.getBigDecimal()));
            }
            catch (Exception exception) {
                throw new FunctionException("Two numeric arguments are required.", exception);
            }
        }
        return new FunctionResult(extendedBigDecimal);
    }
}

