/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.com.docmosis.function.math;

import ch.obermuhlner.math.big.docmosis.BigDecimalMath;
import net.sourceforge.jeval.com.docmosis.Evaluator;
import net.sourceforge.jeval.com.docmosis.ExtendedBigDecimal;
import net.sourceforge.jeval.com.docmosis.function.Function;
import net.sourceforge.jeval.com.docmosis.function.FunctionException;
import net.sourceforge.jeval.com.docmosis.function.FunctionHelper;
import net.sourceforge.jeval.com.docmosis.function.FunctionResult;

public class Exp
implements Function {
    @Override
    public String getName() {
        return "exp";
    }

    @Override
    public FunctionResult execute(Evaluator evaluator, String[] stringArray) throws FunctionException {
        ExtendedBigDecimal extendedBigDecimal = null;
        ExtendedBigDecimal extendedBigDecimal2 = null;
        try {
            extendedBigDecimal2 = ExtendedBigDecimal.valueOf(FunctionHelper.trimAndRemoveQuoteChars(stringArray[0], evaluator.getQuoteCharacter(), false));
        }
        catch (Exception exception) {
            throw new FunctionException("Invalid argument.", exception);
        }
        if (extendedBigDecimal2.isNaN() || extendedBigDecimal2.isPositiveInfinity()) {
            return new FunctionResult(extendedBigDecimal2);
        }
        if (extendedBigDecimal2.isNegativeInfinity()) {
            return new FunctionResult(ExtendedBigDecimal.ZERO);
        }
        try {
            extendedBigDecimal = new ExtendedBigDecimal(BigDecimalMath.exp(extendedBigDecimal2.getBigDecimal(), FunctionHelper.getDefaultMathContext()));
        }
        catch (ArithmeticException arithmeticException) {
            throw new FunctionException("Unable to calculate exponent", arithmeticException);
        }
        return new FunctionResult(extendedBigDecimal);
    }
}

