/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.com.docmosis.function.math;

import ch.obermuhlner.math.big.docmosis.BigDecimalMath;
import java.util.ArrayList;
import net.sourceforge.jeval.com.docmosis.Evaluator;
import net.sourceforge.jeval.com.docmosis.ExtendedBigDecimal;
import net.sourceforge.jeval.com.docmosis.function.Function;
import net.sourceforge.jeval.com.docmosis.function.FunctionException;
import net.sourceforge.jeval.com.docmosis.function.FunctionHelper;
import net.sourceforge.jeval.com.docmosis.function.FunctionResult;

public class Atan2
implements Function {
    @Override
    public String getName() {
        return "atan2";
    }

    @Override
    public FunctionResult execute(Evaluator evaluator, String[] stringArray) throws FunctionException {
        ExtendedBigDecimal extendedBigDecimal = null;
        ArrayList<ExtendedBigDecimal> arrayList = FunctionHelper.getExtendedBigDecimal(stringArray, ',');
        if (arrayList.size() != 2) {
            throw new FunctionException("Two numeric arguments are required.");
        }
        ExtendedBigDecimal extendedBigDecimal2 = arrayList.get(0);
        ExtendedBigDecimal extendedBigDecimal3 = arrayList.get(1);
        if (extendedBigDecimal2.isNaN() || extendedBigDecimal3.isNaN()) {
            extendedBigDecimal = ExtendedBigDecimal.NAN;
        } else if (extendedBigDecimal2.isInfinity() || extendedBigDecimal3.isInfinity()) {
            ArrayList arrayList2 = FunctionHelper.getDoubles(stringArray, ',');
            double d = (Double)arrayList2.get(0);
            double d2 = (Double)arrayList2.get(1);
            extendedBigDecimal = ExtendedBigDecimal.valueOf(Math.atan2(d, d2));
        } else {
            try {
                extendedBigDecimal = new ExtendedBigDecimal(BigDecimalMath.atan2(extendedBigDecimal2.getBigDecimal(), extendedBigDecimal3.getBigDecimal(), FunctionHelper.getDefaultMathContext()));
            }
            catch (Exception exception) {
                throw new FunctionException("Two numeric arguments are required.", exception);
            }
        }
        return new FunctionResult(extendedBigDecimal);
    }
}

