/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.com.docmosis.function.math;

import ch.obermuhlner.math.big.docmosis.BigDecimalMath;
import java.math.BigDecimal;
import net.sourceforge.jeval.com.docmosis.Evaluator;
import net.sourceforge.jeval.com.docmosis.ExtendedBigDecimal;
import net.sourceforge.jeval.com.docmosis.function.Function;
import net.sourceforge.jeval.com.docmosis.function.FunctionException;
import net.sourceforge.jeval.com.docmosis.function.FunctionHelper;
import net.sourceforge.jeval.com.docmosis.function.FunctionResult;

public class Atan
implements Function {
    @Override
    public String getName() {
        return "atan";
    }

    @Override
    public FunctionResult execute(Evaluator evaluator, String[] stringArray) throws FunctionException {
        ExtendedBigDecimal extendedBigDecimal = null;
        ExtendedBigDecimal extendedBigDecimal2 = null;
        try {
            extendedBigDecimal2 = ExtendedBigDecimal.valueOf(FunctionHelper.trimAndRemoveQuoteChars(stringArray[0], evaluator.getQuoteCharacter(), false));
        }
        catch (Exception exception) {
            throw new FunctionException("Invalid argument.", exception);
        }
        if (extendedBigDecimal2.isNaN()) {
            return new FunctionResult(ExtendedBigDecimal.NAN);
        }
        if (extendedBigDecimal2.isPositiveInfinity()) {
            return new FunctionResult(new ExtendedBigDecimal(BigDecimalMath.pi(FunctionHelper.getDefaultMathContext()).divide(new BigDecimal(2, FunctionHelper.getDefaultMathContext()))));
        }
        if (extendedBigDecimal2.isNegativeInfinity()) {
            return new FunctionResult(new ExtendedBigDecimal(BigDecimalMath.pi(FunctionHelper.getDefaultMathContext()).divide(new BigDecimal(2, FunctionHelper.getDefaultMathContext())).negate(FunctionHelper.getDefaultMathContext())));
        }
        extendedBigDecimal = new ExtendedBigDecimal(BigDecimalMath.atan(extendedBigDecimal2.getBigDecimal(), FunctionHelper.getDefaultMathContext()));
        return new FunctionResult(extendedBigDecimal);
    }

    public static void main(String[] stringArray) {
        System.out.println(Math.atan(Double.POSITIVE_INFINITY));
    }
}

