/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.com.docmosis.function.math;

import net.sourceforge.jeval.com.docmosis.Evaluator;
import net.sourceforge.jeval.com.docmosis.ExtendedBigDecimal;
import net.sourceforge.jeval.com.docmosis.function.Function;
import net.sourceforge.jeval.com.docmosis.function.FunctionException;
import net.sourceforge.jeval.com.docmosis.function.FunctionHelper;
import net.sourceforge.jeval.com.docmosis.function.FunctionResult;

public class Abs
implements Function {
    @Override
    public String getName() {
        return "abs";
    }

    @Override
    public FunctionResult execute(Evaluator evaluator, String[] stringArray) throws FunctionException {
        ExtendedBigDecimal extendedBigDecimal = null;
        try {
            extendedBigDecimal = ExtendedBigDecimal.valueOf(FunctionHelper.trimAndRemoveQuoteChars(stringArray[0], evaluator.getQuoteCharacter(), false));
        }
        catch (Exception exception) {
            throw new FunctionException("Invalid argument.", exception);
        }
        return new FunctionResult(Abs.abs(extendedBigDecimal));
    }

    static ExtendedBigDecimal abs(ExtendedBigDecimal extendedBigDecimal) {
        ExtendedBigDecimal extendedBigDecimal2 = null;
        extendedBigDecimal2 = extendedBigDecimal.isNaN() ? extendedBigDecimal : (extendedBigDecimal.isInfinity() ? ExtendedBigDecimal.POSITIVE_INFINITY : new ExtendedBigDecimal(extendedBigDecimal.getBigDecimal().abs(FunctionHelper.getDefaultMathContext())));
        return extendedBigDecimal2;
    }
}

