/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.com.docmosis.function;

import com.docmosis.util.DMProperties;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import net.sourceforge.jeval.com.docmosis.EvalHelper;
import net.sourceforge.jeval.com.docmosis.ExtendedBigDecimal;
import net.sourceforge.jeval.com.docmosis.function.FunctionException;

public class FunctionHelper {
    public static String trimAndRemoveQuoteChars(String string, char c) throws FunctionException {
        return FunctionHelper.trimAndRemoveQuoteChars(string, c, true);
    }

    public static String trimAndRemoveQuoteChars(String string, char c, boolean bl) throws FunctionException {
        String string2 = string;
        if (string2 != null) {
            if ((string2 = string2.trim()).charAt(0) == c) {
                string2 = string2.substring(1, string2.length());
            } else if (bl) {
                throw new FunctionException("Value does not start with a quote.");
            }
            if (string2.charAt(string2.length() - 1) == c) {
                string2 = string2.substring(0, string2.length() - 1);
            } else if (bl) {
                throw new FunctionException("Value does not end with a quote.");
            }
        }
        return string2;
    }

    public static ArrayList getDoubles(String[] stringArray, char c) throws FunctionException {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = EvalHelper.stripQuotes(stringArray[i].trim(), '\'');
                arrayList.add(Double.valueOf(string));
            }
        }
        catch (Exception exception) {
            throw new FunctionException("Invalid values in string.", exception);
        }
        return arrayList;
    }

    public static ArrayList<ExtendedBigDecimal> getExtendedBigDecimal(String[] stringArray, char c) throws FunctionException {
        ArrayList<ExtendedBigDecimal> arrayList = new ArrayList<ExtendedBigDecimal>();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = EvalHelper.stripQuotes(stringArray[i].trim(), '\'');
                arrayList.add(ExtendedBigDecimal.valueOf(string));
            }
        }
        catch (Exception exception) {
            throw new FunctionException("Invalid values in string.", exception);
        }
        return arrayList;
    }

    public static ArrayList getOneStringAndOneInteger(String[] stringArray, char c) throws FunctionException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            int n = 0;
            for (n = 0; n < stringArray.length; ++n) {
                String string;
                if (n == 0) {
                    string = stringArray[n];
                    arrayList.add(string);
                    continue;
                }
                if (n == 1) {
                    string = EvalHelper.stripQuotes(stringArray[n].trim(), '\'');
                    arrayList.add(Double.valueOf(string).intValue());
                    continue;
                }
                throw new FunctionException("Invalid values in string.");
            }
        }
        catch (Exception exception) {
            throw new FunctionException("Invalid values in string.", exception);
        }
        return arrayList;
    }

    public static ArrayList getTwoStringsAndOneInteger(String[] stringArray, char c) throws FunctionException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            int n = 0;
            for (n = 0; n < stringArray.length; ++n) {
                String string;
                if (n == 0 || n == 1) {
                    string = stringArray[n];
                    arrayList.add(string);
                    continue;
                }
                if (n == 2) {
                    string = EvalHelper.stripQuotes(stringArray[n].trim(), '\'');
                    arrayList.add(Double.valueOf(string).intValue());
                    continue;
                }
                throw new FunctionException("Invalid values in string.");
            }
        }
        catch (Exception exception) {
            throw new FunctionException("Invalid values in string.", exception);
        }
        return arrayList;
    }

    public static ArrayList getOneStringAndTwoIntegers(String[] stringArray, char c) throws FunctionException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        try {
            for (n = 0; n < stringArray.length; ++n) {
                String string;
                if (n == 0) {
                    string = stringArray[n];
                    string = string == null ? string : string.trim();
                    arrayList.add(string);
                    continue;
                }
                if (n == 1 || n == 2) {
                    string = EvalHelper.stripQuotes(stringArray[n].trim(), '\'');
                    arrayList.add(Double.valueOf(string).intValue());
                    continue;
                }
                throw new FunctionException("Invalid values in string.");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new FunctionException("Parameter " + (n + 1) + " must be an integer.", numberFormatException);
        }
        catch (Exception exception) {
            throw new FunctionException("Invalid values in string.", exception);
        }
        return arrayList;
    }

    public static MathContext getDefaultMathContext() {
        int n = DMProperties.getInt("docmosis.evaluator.math.precision", 64);
        return new MathContext(n, RoundingMode.HALF_UP);
    }
}

