/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.com.docmosis;

import java.math.BigDecimal;
import net.sourceforge.jeval.com.docmosis.function.FunctionHelper;

public class ExtendedBigDecimal
implements Comparable<ExtendedBigDecimal> {
    public static ExtendedBigDecimal NAN = new ExtendedBigDecimal(null, true, false, false);
    public static ExtendedBigDecimal POSITIVE_INFINITY = new ExtendedBigDecimal(null, false, true, false);
    public static ExtendedBigDecimal NEGATIVE_INFINITY = new ExtendedBigDecimal(null, false, false, true);
    public static ExtendedBigDecimal ZERO = new ExtendedBigDecimal(new BigDecimal("0.0"), false, false, false);
    public static ExtendedBigDecimal ONE = new ExtendedBigDecimal(new BigDecimal("1.0"), false, false, false);
    private static final String G = "NaN";
    private static final String C = "Infinity";
    private static final String B = "-Infinity";
    private BigDecimal A;
    private boolean F;
    private boolean E;
    private boolean D;

    public ExtendedBigDecimal(BigDecimal bigDecimal) {
        this(bigDecimal, true);
    }

    public ExtendedBigDecimal(BigDecimal bigDecimal, boolean bl) {
        this.A = bl ? ExtendedBigDecimal.cleanupBigDecimal(bigDecimal) : bigDecimal;
        this.F = false;
        this.E = false;
        this.D = false;
    }

    public ExtendedBigDecimal(BigDecimal bigDecimal, boolean bl, boolean bl2, boolean bl3) {
        this.A = bigDecimal;
        this.F = bl;
        this.E = bl2;
        this.D = bl3;
    }

    public static ExtendedBigDecimal valueOf(String string) throws NumberFormatException {
        ExtendedBigDecimal extendedBigDecimal = ExtendedBigDecimal.checkNanInfinity(Double.parseDouble(string));
        if (extendedBigDecimal != null) {
            return extendedBigDecimal;
        }
        BigDecimal bigDecimal = ExtendedBigDecimal.cleanupBigDecimal(new BigDecimal(string, FunctionHelper.getDefaultMathContext()));
        extendedBigDecimal = new ExtendedBigDecimal(bigDecimal);
        return extendedBigDecimal;
    }

    public static ExtendedBigDecimal valueOf(double d) throws NumberFormatException {
        ExtendedBigDecimal extendedBigDecimal = ExtendedBigDecimal.checkNanInfinity(d);
        if (extendedBigDecimal != null) {
            return extendedBigDecimal;
        }
        BigDecimal bigDecimal = ExtendedBigDecimal.cleanupBigDecimal(new BigDecimal(d, FunctionHelper.getDefaultMathContext()));
        extendedBigDecimal = new ExtendedBigDecimal(bigDecimal);
        return extendedBigDecimal;
    }

    static ExtendedBigDecimal checkNanInfinity(double d) {
        if (Double.isNaN(d)) {
            return NAN;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        return null;
    }

    private static BigDecimal cleanupBigDecimal(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = bigDecimal.stripTrailingZeros();
        if (bigDecimal2.compareTo(ZERO.getBigDecimal()) == 0) {
            return ZERO.getBigDecimal();
        }
        bigDecimal2 = bigDecimal2.setScale(Math.max(1, bigDecimal2.scale()));
        return bigDecimal2;
    }

    public BigDecimal getBigDecimal() {
        return this.A;
    }

    public boolean isNaN() {
        return this.F;
    }

    public boolean isInfinity() {
        return this.isPositiveInfinity() || this.isNegativeInfinity();
    }

    public boolean isPositiveInfinity() {
        return this.E;
    }

    public boolean isNegativeInfinity() {
        return this.D;
    }

    public String toString() {
        if (this.isNaN()) {
            return G;
        }
        if (this.isPositiveInfinity()) {
            return C;
        }
        if (this.isNegativeInfinity()) {
            return B;
        }
        return this.A.toString();
    }

    @Override
    public int compareTo(ExtendedBigDecimal extendedBigDecimal) {
        if (this.F || extendedBigDecimal.F) {
            return 0;
        }
        if (this.E) {
            if (extendedBigDecimal.E) {
                return 0;
            }
            return 1;
        }
        if (extendedBigDecimal.E) {
            return -1;
        }
        if (this.D) {
            if (extendedBigDecimal.D) {
                return 0;
            }
            return -1;
        }
        if (extendedBigDecimal.D) {
            return 1;
        }
        return this.A.compareTo(extendedBigDecimal.A);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.A == null ? 0 : this.A.hashCode());
        n2 = 31 * n2 + (this.F ? 1231 : 1237);
        n2 = 31 * n2 + (this.D ? 1231 : 1237);
        n2 = 31 * n2 + (this.E ? 1231 : 1237);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExtendedBigDecimal extendedBigDecimal = (ExtendedBigDecimal)object;
        if (this.A == null ? extendedBigDecimal.A != null : !this.A.equals(extendedBigDecimal.A)) {
            return false;
        }
        if (this.F != extendedBigDecimal.F) {
            return false;
        }
        if (this.D != extendedBigDecimal.D) {
            return false;
        }
        return this.E == extendedBigDecimal.E;
    }
}

