/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.com.docmosis;

import net.sourceforge.jeval.com.docmosis.EvaluationException;
import net.sourceforge.jeval.com.docmosis.Evaluator;
import net.sourceforge.jeval.com.docmosis.ExpressionOperand;
import net.sourceforge.jeval.com.docmosis.ExtendedBigDecimal;
import net.sourceforge.jeval.com.docmosis.ParsedFunction;
import net.sourceforge.jeval.com.docmosis.function.Function;
import net.sourceforge.jeval.com.docmosis.function.FunctionException;
import net.sourceforge.jeval.com.docmosis.function.FunctionResult;
import net.sourceforge.jeval.com.docmosis.operator.Operator;

public class ExpressionTree {
    private Object D = null;
    private Object C = null;
    private Operator A = null;
    private Operator B = null;
    private Evaluator E = null;

    public ExpressionTree(Evaluator evaluator, Object object, Object object2, Operator operator, Operator operator2) {
        this.E = evaluator;
        this.D = object;
        this.C = object2;
        this.A = operator;
        this.B = operator2;
    }

    public Object getLeftOperand() {
        return this.D;
    }

    public Object getRightOperand() {
        return this.C;
    }

    public Operator getOperator() {
        return this.A;
    }

    public Operator getUnaryOperator() {
        return this.B;
    }

    public String evaluate(boolean bl) throws EvaluationException {
        String string = null;
        _A _A2 = ExpressionTree.evaluateOperand(this.D, bl, this.E);
        _A _A3 = ExpressionTree.evaluateOperand(this.C, bl, this.E);
        String string2 = _A2.B();
        ExtendedBigDecimal extendedBigDecimal = _A2.A();
        String string3 = _A3.B();
        ExtendedBigDecimal extendedBigDecimal2 = _A3.A();
        if (extendedBigDecimal != null && extendedBigDecimal2 != null) {
            ExtendedBigDecimal extendedBigDecimal3 = this.A.evaluate(extendedBigDecimal, extendedBigDecimal2);
            if (this.getUnaryOperator() != null) {
                extendedBigDecimal3 = this.getUnaryOperator().evaluate(extendedBigDecimal3);
            }
            string = extendedBigDecimal3.toString();
        } else if (string2 != null && string3 != null) {
            ExtendedBigDecimal[] extendedBigDecimalArray = this.E.stringsToBigDecimal(string2, string3);
            if (extendedBigDecimalArray != null) {
                ExtendedBigDecimal extendedBigDecimal4 = this.A.evaluate(extendedBigDecimalArray[0], extendedBigDecimalArray[1]);
                if (this.getUnaryOperator() != null) {
                    extendedBigDecimal4 = this.getUnaryOperator().evaluate(extendedBigDecimal4);
                }
                string = extendedBigDecimal4.toString();
            } else {
                try {
                    string = this.A.evaluate(string2, string3);
                }
                catch (EvaluationException evaluationException) {
                    if (this.E.getFieldParserSettings() != null && this.E.getFieldParserSettings().forgivingParseMode()) {
                        string = "0.0";
                    }
                    throw evaluationException;
                }
            }
        } else if (extendedBigDecimal != null || extendedBigDecimal2 != null) {
            if (extendedBigDecimal == null) {
                if (string2 != null) {
                    try {
                        extendedBigDecimal = ExtendedBigDecimal.valueOf(this.E.stripQuotes(string2));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    extendedBigDecimal = ExtendedBigDecimal.ZERO;
                }
            } else if (extendedBigDecimal2 == null) {
                if (string3 != null) {
                    try {
                        extendedBigDecimal2 = ExtendedBigDecimal.valueOf(this.E.stripQuotes(string3));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    extendedBigDecimal2 = ExtendedBigDecimal.ZERO;
                }
            }
            if (this.B != null && extendedBigDecimal != null) {
                string = this.B.evaluate(extendedBigDecimal).toString();
            } else if (extendedBigDecimal == null || extendedBigDecimal2 == null) {
                if (string2 == null) {
                    string2 = this.E.getQuoteCharacter() + String.valueOf(extendedBigDecimal) + this.E.getQuoteCharacter();
                }
                if (string3 == null) {
                    string3 = this.E.getQuoteCharacter() + String.valueOf(extendedBigDecimal2) + this.E.getQuoteCharacter();
                }
                try {
                    string = this.A.evaluate(string2, string3);
                }
                catch (EvaluationException evaluationException) {
                    if (this.E.getFieldParserSettings() != null && this.E.getFieldParserSettings().forgivingParseMode()) {
                        string = "0.0";
                    }
                    throw evaluationException;
                }
            } else {
                string = this.A.evaluate(extendedBigDecimal, extendedBigDecimal2).toString();
            }
        } else if (this.B != null) {
            string = this.B.evaluate(string2, null);
        } else {
            boolean bl2 = this.E.isQuoted(string2);
            boolean bl3 = this.E.isQuoted(string3);
            if (bl2 && !bl3 && string3 != null) {
                string3 = this.E.getQuoteCharacter() + string3 + this.E.getQuoteCharacter();
            } else if (!bl2 && bl3 && string2 != null) {
                string2 = this.E.getQuoteCharacter() + string2 + this.E.getQuoteCharacter();
            }
            string = this.A.evaluate(string2, string3);
        }
        return string;
    }

    private static _A evaluateOperand(Object object, boolean bl, Evaluator evaluator) throws EvaluationException {
        String string = null;
        ExtendedBigDecimal extendedBigDecimal = null;
        if (object != null) {
            if (object instanceof ExpressionTree) {
                string = ((ExpressionTree)object).evaluate(bl);
                try {
                    extendedBigDecimal = ExtendedBigDecimal.valueOf(string);
                    string = null;
                }
                catch (NumberFormatException numberFormatException) {
                    extendedBigDecimal = null;
                }
            } else if (object instanceof ExpressionOperand) {
                ExpressionOperand expressionOperand = (ExpressionOperand)object;
                string = expressionOperand.getValue();
                try {
                    evaluator.isValidName(string);
                    if (!Evaluator.isBooleanLiteral(string)) {
                        string = evaluator.getVariableValue(string);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (Evaluator.isBooleanLiteral(string)) {
                    string = evaluator.getQuoteCharacter() + string + evaluator.getQuoteCharacter();
                    if (expressionOperand.getUnaryOperator() != null) {
                        string = expressionOperand.getUnaryOperator().evaluate(string, null);
                    }
                } else if (string == null) {
                    string = evaluator.getQuoteCharacter() + string + evaluator.getQuoteCharacter();
                    if (expressionOperand.getUnaryOperator() != null) {
                        try {
                            string = expressionOperand.getUnaryOperator().evaluate(string, null);
                        }
                        catch (EvaluationException evaluationException) {
                            if (evaluator.getFieldParserSettings() != null && evaluator.getFieldParserSettings().forgivingParseMode()) {
                                string = "0.0";
                            }
                            throw evaluationException;
                        }
                    }
                } else if (!evaluator.isExpressionString(string)) {
                    try {
                        extendedBigDecimal = ExtendedBigDecimal.valueOf(string);
                        string = null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new EvaluationException("Expression is invalid.", numberFormatException);
                    }
                    if (expressionOperand.getUnaryOperator() != null) {
                        extendedBigDecimal = expressionOperand.getUnaryOperator().evaluate(extendedBigDecimal);
                    }
                } else if (expressionOperand.getUnaryOperator() != null) {
                    throw new EvaluationException("Invalid operand for unary operator.");
                }
            } else if (object instanceof ParsedFunction) {
                ParsedFunction parsedFunction = (ParsedFunction)object;
                Function function = parsedFunction.getFunction();
                String[] stringArray = parsedFunction.getArgumentsArray();
                stringArray = evaluator.replaceVariables(stringArray);
                if (evaluator.getProcessNestedFunctions()) {
                    stringArray = evaluator.processNestedFunctions(stringArray);
                }
                try {
                    FunctionResult functionResult = function.execute(evaluator, stringArray);
                    if (functionResult.getType() == 0) {
                        ExtendedBigDecimal extendedBigDecimal2 = functionResult.getResultBigDecimal();
                        if (parsedFunction.getUnaryOperator() != null) {
                            extendedBigDecimal2 = parsedFunction.getUnaryOperator().evaluate(extendedBigDecimal2);
                        }
                        string = extendedBigDecimal2.toString();
                    } else if (functionResult.getType() == 1) {
                        string = functionResult.getResultStr();
                        if (parsedFunction.getUnaryOperator() != null) {
                            if ("false".equals(string)) {
                                string = String.valueOf(parsedFunction.getUnaryOperator().evaluate(ExtendedBigDecimal.ZERO));
                            } else if ("true".equals(string)) {
                                string = String.valueOf(parsedFunction.getUnaryOperator().evaluate(ExtendedBigDecimal.ONE));
                            } else {
                                throw new EvaluationException("Invalid operand for unary operator.");
                            }
                            if (parsedFunction.getUnaryOperator().isBoolean()) {
                                string = Boolean.valueOf("1.0".equals(string)).toString();
                            }
                        }
                        if (bl) {
                            string = evaluator.getQuoteCharacter() + string + evaluator.getQuoteCharacter();
                        }
                    }
                }
                catch (FunctionException functionException) {
                    throw new EvaluationException(function.getName() + "(). " + functionException.getMessage(), functionException);
                }
                if (!evaluator.isExpressionString(string)) {
                    try {
                        extendedBigDecimal = ExtendedBigDecimal.valueOf(string);
                        string = null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new EvaluationException("Expression is invalid.", numberFormatException);
                    }
                }
            } else {
                throw new EvaluationException("Expression is invalid.");
            }
        }
        return new _A(string, extendedBigDecimal);
    }

    private static class _A {
        private final String B;
        private final ExtendedBigDecimal A;

        public _A(String string, ExtendedBigDecimal extendedBigDecimal) {
            this.B = string;
            this.A = extendedBigDecimal;
        }

        public String B() {
            return this.B;
        }

        public ExtendedBigDecimal A() {
            return this.A;
        }
    }
}

