/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.com.docmosis;

import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.sourceforge.jeval.com.docmosis.ArgumentTokenizer;
import net.sourceforge.jeval.com.docmosis.EvalHelper;
import net.sourceforge.jeval.com.docmosis.EvaluationException;
import net.sourceforge.jeval.com.docmosis.EvaluationHelper;
import net.sourceforge.jeval.com.docmosis.ExpressionOperand;
import net.sourceforge.jeval.com.docmosis.ExpressionOperator;
import net.sourceforge.jeval.com.docmosis.ExpressionTree;
import net.sourceforge.jeval.com.docmosis.ExtendedBigDecimal;
import net.sourceforge.jeval.com.docmosis.FieldParserSettings;
import net.sourceforge.jeval.com.docmosis.FunctionResolver;
import net.sourceforge.jeval.com.docmosis.NextOperator;
import net.sourceforge.jeval.com.docmosis.ParsedFunction;
import net.sourceforge.jeval.com.docmosis.VariableResolver;
import net.sourceforge.jeval.com.docmosis.function.Function;
import net.sourceforge.jeval.com.docmosis.function.FunctionException;
import net.sourceforge.jeval.com.docmosis.function.FunctionGroup;
import net.sourceforge.jeval.com.docmosis.function.FunctionResult;
import net.sourceforge.jeval.com.docmosis.function.math.MathFunctions;
import net.sourceforge.jeval.com.docmosis.function.string.StringFunctions;
import net.sourceforge.jeval.com.docmosis.operator.AbstractOperator;
import net.sourceforge.jeval.com.docmosis.operator.AdditionOperator;
import net.sourceforge.jeval.com.docmosis.operator.BooleanAndOperator;
import net.sourceforge.jeval.com.docmosis.operator.BooleanNotOperator;
import net.sourceforge.jeval.com.docmosis.operator.BooleanOrOperator;
import net.sourceforge.jeval.com.docmosis.operator.CloseParenthesesOperator;
import net.sourceforge.jeval.com.docmosis.operator.DivisionOperator;
import net.sourceforge.jeval.com.docmosis.operator.Equal2Operator;
import net.sourceforge.jeval.com.docmosis.operator.EqualOperator;
import net.sourceforge.jeval.com.docmosis.operator.GreaterThanOperator;
import net.sourceforge.jeval.com.docmosis.operator.GreaterThanOrEqualOperator;
import net.sourceforge.jeval.com.docmosis.operator.LessThanOperator;
import net.sourceforge.jeval.com.docmosis.operator.LessThanOrEqualOperator;
import net.sourceforge.jeval.com.docmosis.operator.ModulusOperator;
import net.sourceforge.jeval.com.docmosis.operator.MultiplicationOperator;
import net.sourceforge.jeval.com.docmosis.operator.NotEqualOperator;
import net.sourceforge.jeval.com.docmosis.operator.OpenParenthesesOperator;
import net.sourceforge.jeval.com.docmosis.operator.Operator;
import net.sourceforge.jeval.com.docmosis.operator.SubtractionOperator;
import net.sourceforge.jeval.com.docmosis.operator.SubtractionOperator2;

public class Evaluator {
    private static final Logger H = LogManager.getLogger(Evaluator.class);
    private static Set L = Collections.synchronizedSet(new HashSet());
    private List O = new ArrayList();
    private Map M = new HashMap();
    private Map G = new HashMap();
    private char N = (char)39;
    private Operator K = new OpenParenthesesOperator();
    private Operator B = new CloseParenthesesOperator();
    private boolean S;
    private boolean F;
    private boolean D;
    private boolean R;
    private String E = null;
    private Stack C = null;
    private Stack I = null;
    private Stack T = null;
    private Stack P = null;
    private VariableResolver J = null;
    private FunctionResolver A = null;
    private FieldParserSettings Q = null;

    public Evaluator() {
        this('\'', true, true, true, true, null);
    }

    public Evaluator(char c, boolean bl, boolean bl2, boolean bl3, boolean bl4, FieldParserSettings fieldParserSettings) {
        this.installOperators();
        this.S = bl;
        this.loadSystemVariables();
        this.F = bl2;
        this.D = bl3;
        this.loadSystemFunctions();
        this.setQuoteCharacter(c);
        this.R = bl4;
        this.Q = fieldParserSettings;
    }

    public char getQuoteCharacter() {
        return this.N;
    }

    public void setQuoteCharacter(char c) {
        if (c != '\'' && c != '\"') {
            throw new IllegalArgumentException("Invalid quote character.");
        }
        this.N = c;
    }

    public void putFunction(Function function) {
        String string;
        this.isValidName(function.getName());
        Function function2 = (Function)this.M.get(function.getName());
        if (function2 != null && H.isDebugEnabled() && !L.contains(string = "Template function " + function.getName() + "() overridden with " + function.getClass().getName())) {
            L.add(string);
            H.debug(string);
        }
        this.M.put(function.getName(), function);
    }

    public void setFunctionResolver(FunctionResolver functionResolver) {
        this.A = functionResolver;
    }

    public void setFieldParserSettings(FieldParserSettings fieldParserSettings) {
        this.Q = fieldParserSettings;
    }

    public FieldParserSettings getFieldParserSettings() {
        return this.Q;
    }

    public Function getFunction(String string) {
        return (Function)this.M.get(string);
    }

    public void removeFunction(String string) {
        if (!this.M.containsKey(string)) {
            throw new IllegalArgumentException("The function does not exist.");
        }
        this.M.remove(string);
    }

    public void clearFunctions() {
        this.M.clear();
        this.loadSystemFunctions();
    }

    public Map getFunctions() {
        return this.M;
    }

    public void setFunctions(Map map) {
        this.M = map;
    }

    public void putVariable(String string, String string2) {
        this.isValidName(string);
        this.G.put(string, string2);
    }

    public String getVariableValue(String string) throws EvaluationException {
        String string2 = null;
        if (this.J != null) {
            try {
                string2 = this.J.resolveVariable(string);
            }
            catch (FunctionException functionException) {
                throw new EvaluationException(functionException.getMessage(), functionException);
            }
        }
        if (string2 == null) {
            string2 = (String)this.G.get(string);
        }
        if (string2 == null) {
            // empty if block
        }
        return string2;
    }

    public void removeVaraible(String string) {
        if (!this.G.containsKey(string)) {
            throw new IllegalArgumentException("The variable does not exist.");
        }
        this.G.remove(string);
    }

    public void clearVariables() {
        this.G.clear();
        this.loadSystemVariables();
    }

    public Map getVariables() {
        return this.G;
    }

    public void setVariables(Map map) {
        this.G = map;
    }

    public VariableResolver getVariableResolver() {
        return this.J;
    }

    public void setVariableResolver(VariableResolver variableResolver) {
        this.J = variableResolver;
    }

    public String evaluate(String string) throws EvaluationException {
        return this.evaluate(string, true, true);
    }

    public String evaluate() throws EvaluationException {
        String string = this.E;
        if (string == null || string.length() == 0) {
            throw new EvaluationException("No expression has been specified.");
        }
        return this.evaluate(string, true, true);
    }

    public String evaluate(String string, boolean bl, boolean bl2) throws EvaluationException {
        Object object;
        this.parse(string);
        if (!this.T.isEmpty() && (object = this.T.peek()) instanceof ExpressionOperator) {
            if ((object = ((ExpressionOperator)object).getOperator()) instanceof OpenParenthesesOperator) {
                throw new EvaluationException("Missing a close bracket");
            }
            if (object instanceof CloseParenthesesOperator) {
                throw new EvaluationException("Missing an open bracket");
            }
        }
        if (this.isExpressionString((String)(object = this.getResult(this.T, this.P, bl2))) && !bl) {
            object = ((String)object).substring(1, ((String)object).length() - 1);
        }
        return object;
    }

    public boolean getBooleanResult(String string) throws EvaluationException {
        String string2 = this.evaluate(string);
        try {
            Double d = Double.valueOf(string2);
            if (d == 1.0) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return false;
    }

    public double getNumberResult(String string) throws EvaluationException {
        String string2 = this.evaluate(string);
        Double d = null;
        try {
            d = Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new EvaluationException("Expression does not produce a number.", numberFormatException);
        }
        return d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(String string) throws EvaluationException {
        boolean bl = true;
        if (!string.equals(this.E)) {
            this.E = string;
        } else {
            bl = false;
            this.T = (Stack)this.C.clone();
            this.P = (Stack)this.I.clone();
        }
        try {
            if (!bl) return;
            this.P = new Stack();
            this.T = new Stack();
            boolean bl2 = false;
            boolean bl3 = false;
            Operator operator = null;
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                Operator operator2 = null;
                int n3 = -1;
                if (EvaluationHelper.isSpace(string.charAt(n2))) {
                    ++n2;
                    continue;
                }
                NextOperator nextOperator = this.getNextOperator(string, n2, null);
                if (nextOperator != null) {
                    operator2 = nextOperator.getOperator();
                    n3 = nextOperator.getIndex();
                }
                if (n3 > n2 || n3 == -1) {
                    n2 = this.processOperand(string, n2, n3, this.P, operator);
                    bl2 = true;
                    bl3 = false;
                    operator = null;
                }
                if (n3 != n2) continue;
                if (nextOperator.getOperator().isUnary() && (bl3 || this.P.isEmpty() && this.T.isEmpty())) {
                    n2 = this.processUnaryOperator(n3, nextOperator.getOperator());
                    if (operator != null) throw new EvaluationException("Consecutive unary operators are not allowed (index=" + n2 + ").");
                    operator = nextOperator.getOperator();
                } else {
                    n2 = this.processOperator(string, n3, operator2, this.T, this.P, bl2, operator);
                    operator = null;
                }
                if (nextOperator.getOperator() instanceof CloseParenthesesOperator) continue;
                bl2 = false;
                bl3 = true;
            }
            this.C = (Stack)this.T.clone();
            this.I = (Stack)this.P.clone();
            return;
        }
        catch (Exception exception) {
            this.E = "";
            throw new EvaluationException(exception.getMessage(), exception);
        }
    }

    private void installOperators() {
        this.O.add(this.K);
        this.O.add(this.B);
        this.O.add(new AdditionOperator());
        this.O.add(new SubtractionOperator());
        this.O.add(new SubtractionOperator2());
        this.O.add(new MultiplicationOperator());
        this.O.add(new DivisionOperator());
        this.O.add(new EqualOperator());
        this.O.add(new Equal2Operator());
        this.O.add(new NotEqualOperator());
        this.O.add(new LessThanOrEqualOperator());
        this.O.add(new LessThanOperator());
        this.O.add(new GreaterThanOrEqualOperator());
        this.O.add(new GreaterThanOperator());
        this.O.add(new BooleanAndOperator());
        this.O.add(new BooleanOrOperator());
        this.O.add(new BooleanNotOperator());
        this.O.add(new ModulusOperator());
        for (int i = 0; i < this.O.size(); ++i) {
            ((AbstractOperator)this.O.get(i)).setEvaluator(this);
        }
    }

    private int processOperand(String string, int n, int n2, Stack stack, Operator operator) throws EvaluationException {
        String string2 = null;
        int n3 = -1;
        if (n2 == -1) {
            string2 = string.substring(n).trim();
            n3 = string.length();
        } else {
            string2 = string.substring(n, n2).trim();
            n3 = n2;
        }
        if (string2.length() == 0) {
            throw new EvaluationException("Expression is invalid.");
        }
        ExpressionOperand expressionOperand = new ExpressionOperand(string2, operator);
        stack.push(expressionOperand);
        return n3;
    }

    private int processOperator(String string, int n, Operator operator, Stack stack, Stack stack2, boolean bl, Operator operator2) throws EvaluationException {
        Object object;
        int n2 = n;
        Operator operator3 = operator;
        if (bl && operator3 instanceof OpenParenthesesOperator) {
            object = this.processFunction(string, n2, stack2);
            operator3 = ((NextOperator)object).getOperator();
            n2 = ((NextOperator)object).getIndex() + operator3.getLength();
            if ((object = this.getNextOperator(string, n2, null)) != null) {
                operator3 = ((NextOperator)object).getOperator();
                n2 = ((NextOperator)object).getIndex();
            } else {
                return n2;
            }
        }
        if (operator3 instanceof OpenParenthesesOperator) {
            object = new ExpressionOperator(operator3, operator2);
            stack.push(object);
        } else if (operator3 instanceof CloseParenthesesOperator) {
            object = null;
            if (stack.size() > 0) {
                object = (ExpressionOperator)stack.peek();
            }
            while (object != null && !(((ExpressionOperator)object).getOperator() instanceof OpenParenthesesOperator)) {
                this.processTree(stack2, stack);
                if (stack.size() > 0) {
                    object = (ExpressionOperator)stack.peek();
                    continue;
                }
                object = null;
            }
            if (stack.isEmpty()) {
                throw new EvaluationException("Expression is invalid.");
            }
            ExpressionOperator expressionOperator = (ExpressionOperator)stack.pop();
            if (!(expressionOperator.getOperator() instanceof OpenParenthesesOperator)) {
                throw new EvaluationException("Expression is invalid.");
            }
            if (expressionOperator.getUnaryOperator() != null) {
                Object e = stack2.pop();
                ExpressionTree expressionTree = new ExpressionTree(this, e, null, null, expressionOperator.getUnaryOperator());
                stack2.push(expressionTree);
            }
        } else {
            if (stack.size() > 0) {
                object = (ExpressionOperator)stack.peek();
                while (object != null && ((ExpressionOperator)object).getOperator().getPrecedence() >= operator3.getPrecedence()) {
                    this.processTree(stack2, stack);
                    if (stack.size() > 0) {
                        object = (ExpressionOperator)stack.peek();
                        continue;
                    }
                    object = null;
                }
            }
            object = new ExpressionOperator(operator3, operator2);
            stack.push(object);
        }
        int n3 = n2 + operator3.getLength();
        return n3;
    }

    private int processUnaryOperator(int n, Operator operator) {
        int n2 = n + operator.getSymbol().length();
        return n2;
    }

    private NextOperator processFunction(String string, int n, Stack stack) throws EvaluationException {
        int n2 = 1;
        NextOperator nextOperator = null;
        int n3 = n;
        while (n2 > 0) {
            nextOperator = this.getNextOperator(string, n3 + 1, null);
            if (nextOperator == null) {
                throw new EvaluationException("Function is not closed.");
            }
            if (nextOperator.getOperator() instanceof OpenParenthesesOperator) {
                ++n2;
            } else if (nextOperator.getOperator() instanceof CloseParenthesesOperator) {
                --n2;
            }
            n3 = nextOperator.getIndex();
        }
        String string2 = string.substring(n + 1, n3);
        ExpressionOperand expressionOperand = (ExpressionOperand)stack.pop();
        Operator operator = expressionOperand.getUnaryOperator();
        String string3 = expressionOperand.getValue();
        try {
            this.isValidName(string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EvaluationException("Invalid function name of \"" + string3 + "\".", illegalArgumentException);
        }
        Function function = (Function)this.M.get(string3);
        if (function == null) {
            if (this.A != null) {
                try {
                    function = this.A.resolveFunction(string3);
                }
                catch (FunctionException functionException) {
                    throw new EvaluationException("Error resolving function name [" + string3 + "]", functionException);
                }
            }
            if (function == null) {
                throw new EvaluationException("Function not defined (" + string3 + ").");
            }
        }
        ArgumentTokenizer argumentTokenizer = new ArgumentTokenizer(string2, ',');
        ArrayList<String> arrayList = new ArrayList<String>();
        while (argumentTokenizer.hasMoreElements()) {
            arrayList.add(argumentTokenizer.nextToken());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        ParsedFunction parsedFunction = new ParsedFunction(function, stringArray, operator);
        stack.push(parsedFunction);
        return nextOperator;
    }

    private void processTree(Stack stack, Stack stack2) {
        Object var3_3 = null;
        Object var4_4 = null;
        Operator operator = null;
        if (stack.size() > 0) {
            var3_3 = stack.pop();
        }
        if (stack.size() > 0) {
            var4_4 = stack.pop();
        }
        operator = ((ExpressionOperator)stack2.pop()).getOperator();
        ExpressionTree expressionTree = new ExpressionTree(this, var4_4, var3_3, operator, null);
        stack.push(expressionTree);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getResult(Stack stack, Stack stack2, boolean bl) throws EvaluationException {
        String string = null;
        while (stack.size() > 0) {
            this.processTree(stack2, stack);
        }
        if (stack2.size() != 1) {
            throw new EvaluationException("Expression is invalid.");
        }
        Object e = stack2.pop();
        if (e == null) return string;
        if (e instanceof ExpressionTree) {
            string = ((ExpressionTree)e).evaluate(bl);
            if (((ExpressionTree)e).getOperator() != null && ((ExpressionTree)e).getOperator().isBoolean()) {
                return Boolean.valueOf("1.0".equals(string)).toString();
            }
            if (((ExpressionTree)e).getUnaryOperator() == null) return string;
            if (!((ExpressionTree)e).getUnaryOperator().isBoolean()) return string;
            return Boolean.valueOf("1.0".equals(string)).toString();
        }
        if (e instanceof ExpressionOperand) {
            ExpressionOperand expressionOperand = (ExpressionOperand)e;
            string = ((ExpressionOperand)e).getValue();
            try {
                this.isValidName(string);
                if (!Evaluator.isBooleanLiteral(string)) {
                    string = this.getVariableValue(string);
                }
                if (string == null || Evaluator.isBooleanLiteral(string)) {
                    if (expressionOperand.getUnaryOperator() == null) return string;
                    if (!expressionOperand.getUnaryOperator().isBoolean()) return string;
                    ExtendedBigDecimal extendedBigDecimal = string == null || "false".equals(string) ? ExtendedBigDecimal.ZERO : ExtendedBigDecimal.ONE;
                    extendedBigDecimal = expressionOperand.getUnaryOperator().evaluate(extendedBigDecimal);
                    string = extendedBigDecimal.toString();
                    return Boolean.valueOf("1.0".equals(string)).toString();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (!this.isExpressionString(string)) {
                ExtendedBigDecimal extendedBigDecimal = null;
                try {
                    extendedBigDecimal = ExtendedBigDecimal.valueOf(string);
                }
                catch (Exception exception) {
                    throw new EvaluationException("Expression is invalid.", exception);
                }
                if (expressionOperand.getUnaryOperator() != null) {
                    extendedBigDecimal = expressionOperand.getUnaryOperator().evaluate(extendedBigDecimal);
                }
                string = extendedBigDecimal.toString();
                if (expressionOperand.getUnaryOperator() == null) return string;
                if (!expressionOperand.getUnaryOperator().isBoolean()) return string;
                if (!"1.0".equals(string)) return "false";
                return "true";
            }
            if (expressionOperand.getUnaryOperator() == null) return string;
            return expressionOperand.getUnaryOperator().evaluate(string, null);
        }
        if (!(e instanceof ParsedFunction)) throw new EvaluationException("Expression is invalid.");
        ParsedFunction parsedFunction = (ParsedFunction)e;
        Function function = parsedFunction.getFunction();
        String[] stringArray = parsedFunction.getArgumentsArray();
        if (this.R) {
            stringArray = this.processNestedFunctions(stringArray);
        }
        stringArray = this.replaceVariables(stringArray);
        try {
            FunctionResult functionResult = function.execute(this, stringArray);
            if (functionResult.getType() == 0) {
                ExtendedBigDecimal extendedBigDecimal = functionResult.getResultBigDecimal();
                if (parsedFunction.getUnaryOperator() == null) return extendedBigDecimal.toString();
                extendedBigDecimal = parsedFunction.getUnaryOperator().evaluate(extendedBigDecimal);
                return extendedBigDecimal.toString();
            }
            if (functionResult.getType() != 1) return string;
            string = functionResult.getResultStr();
            if (parsedFunction.getUnaryOperator() != null) {
                if ("false".equals(string)) {
                    string = parsedFunction.getUnaryOperator().evaluate(ExtendedBigDecimal.ZERO).toString();
                } else {
                    if (!"true".equals(string)) throw new EvaluationException("Invalid operand for unary operator.");
                    string = parsedFunction.getUnaryOperator().evaluate(ExtendedBigDecimal.ONE).toString();
                }
                if (parsedFunction.getUnaryOperator().isBoolean()) {
                    string = Boolean.valueOf("1.0".equals(string)).toString();
                }
            }
            if (!bl) return string;
            if (string == null) return string;
            return this.N + string + this.N;
        }
        catch (FunctionException functionException) {
            throw new EvaluationException(function.getName() + "() " + functionException.getMessage(), functionException, functionException.isAssertionFailure());
        }
    }

    private NextOperator getNextOperator(String string, int n, Operator operator) {
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            if (string.charAt(i) == this.N) {
                ++n3;
            }
            if (n3 % 2 == 1) continue;
            if (this.bracketedFieldNamesEnabled()) {
                if (string.charAt(i) == '[') {
                    ++n4;
                } else if (string.charAt(i) == ']') {
                    --n4;
                }
                if (n4 > 0) continue;
            }
            int n5 = this.O.size();
            for (int j = 0; j < n5; ++j) {
                Operator operator2 = (Operator)this.O.get(j);
                if (operator != null && !operator.equals(operator2)) continue;
                if (operator2.getLength() == 2) {
                    int n6 = -1;
                    n6 = i + 2 <= string.length() ? i + 2 : string.length();
                    if (!string.substring(i, n6).equals(operator2.getSymbol())) continue;
                    NextOperator nextOperator = new NextOperator(operator2, i);
                    return nextOperator;
                }
                if (string.charAt(i) != operator2.getSymbol().charAt(0)) continue;
                NextOperator nextOperator = new NextOperator(operator2, i);
                return nextOperator;
            }
        }
        return null;
    }

    protected boolean isExpressionString(String string) throws EvaluationException {
        if (string == null) {
            return false;
        }
        if (string.length() > 1 && string.charAt(0) == this.N && string.charAt(string.length() - 1) == this.N) {
            return true;
        }
        if (string.indexOf(this.N) >= 0) {
            throw new EvaluationException("Invalid use of quotes.");
        }
        return false;
    }

    public void isValidName(String string) throws IllegalArgumentException {
        char c;
        if (string.length() == 0) {
            throw new IllegalArgumentException("Variable is empty.");
        }
        boolean bl = false;
        if (this.bracketedFieldNamesEnabled() && string.startsWith("[")) {
            string = this.Q.unbracket(string);
            if (this.Q.bracketedHyphenatedFieldNameEnabled()) {
                bl = this.Q.isHyphenated(string);
            }
        }
        if ((c = string.charAt(0)) >= '0' && c <= '9') {
            throw new IllegalArgumentException("A variable or function name can not start with a number.");
        }
        if (string.indexOf(39) > -1) {
            throw new IllegalArgumentException("A variable or function name can not contain a quote character.");
        }
        if (string.indexOf(34) > -1) {
            throw new IllegalArgumentException("A variable or function name can not contain a quote character.");
        }
        if (string.indexOf(123) > -1) {
            throw new IllegalArgumentException("A variable or function name can not contain an open brace character.");
        }
        if (string.indexOf(125) > -1) {
            throw new IllegalArgumentException("A variable or function name can not contain a closed brace character.");
        }
        if (string.indexOf(35) > -1) {
            throw new IllegalArgumentException("A variable or function name can not contain a pound sign character.");
        }
        for (Operator operator : this.O) {
            if (string.indexOf(operator.getSymbol()) <= -1 || bl && Evaluator.isSubtractionOperator(operator)) continue;
            throw new IllegalArgumentException("A variable or function name can not contain an operator symbol.");
        }
        if (string.indexOf("!") > -1) {
            throw new IllegalArgumentException("A variable or function name can not contain a special character.");
        }
        if (string.indexOf("~") > -1) {
            throw new IllegalArgumentException("A variable or function name can not contain a special character.");
        }
        if (string.indexOf("^") > -1) {
            throw new IllegalArgumentException("A variable or function name can not contain a special character.");
        }
        if (string.indexOf(",") > -1) {
            throw new IllegalArgumentException("A variable or function name can not contain a special character.");
        }
    }

    private static boolean isSubtractionOperator(Operator operator) {
        return operator instanceof SubtractionOperator;
    }

    private void loadSystemFunctions() {
        FunctionGroup functionGroup;
        if (this.F) {
            functionGroup = new MathFunctions();
            functionGroup.load(this);
        }
        if (this.D) {
            functionGroup = new StringFunctions();
            functionGroup.load(this);
        }
    }

    private void loadSystemVariables() {
        if (this.S) {
            this.putVariable("E", Double.valueOf(Math.E).toString());
            this.putVariable("PI", Double.valueOf(Math.PI).toString());
        }
    }

    public String[] replaceVariables(String[] stringArray) throws EvaluationException {
        return stringArray;
    }

    protected String[] processNestedFunctions(String[] stringArray) throws EvaluationException {
        String[] stringArray2 = null;
        if (stringArray != null) {
            Evaluator evaluator = new Evaluator(this.N, this.S, this.F, this.D, this.R, this.Q);
            evaluator.setFunctions(this.getFunctions());
            evaluator.setVariables(this.getVariables());
            evaluator.setVariableResolver(this.getVariableResolver());
            stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = evaluator.evaluate(stringArray[i]);
            }
        }
        return stringArray2;
    }

    public boolean isLoadMathVariables() {
        return this.S;
    }

    public boolean getLoadMathFunctions() {
        return this.F;
    }

    public boolean getLoadStringFunctions() {
        return this.D;
    }

    public boolean getProcessNestedFunctions() {
        return this.R;
    }

    public ExtendedBigDecimal[] stringsToBigDecimal(String string, String string2) {
        if (string != null && string2 != null) {
            string = this.stripQuotes(string);
            string2 = this.stripQuotes(string2);
            String string3 = string.trim().toLowerCase();
            String string4 = string2.trim().toLowerCase();
            if (string3.endsWith("d") || string3.endsWith("f") || string4.endsWith("d") || string4.endsWith("f")) {
                return null;
            }
            try {
                ExtendedBigDecimal extendedBigDecimal = ExtendedBigDecimal.valueOf(string);
                ExtendedBigDecimal extendedBigDecimal2 = ExtendedBigDecimal.valueOf(string2);
                return new ExtendedBigDecimal[]{extendedBigDecimal, extendedBigDecimal2};
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isQuoted(String string) {
        return EvalHelper.isQuoted(string, this.N);
    }

    public String stripQuotes(String string) {
        return EvalHelper.stripQuotes(string, this.N);
    }

    public DocmosisOperand[] getOperands() throws EvaluationException {
        if (this.E == null) {
            throw new EvaluationException("Evaluator needs to be parsed first");
        }
        ArrayList arrayList = new ArrayList();
        Evaluator.collectOperands(this.P, arrayList);
        DocmosisOperand[] docmosisOperandArray = new DocmosisOperand[arrayList.size()];
        arrayList.toArray(docmosisOperandArray);
        return docmosisOperandArray;
    }

    public Stack getOperators() {
        return (Stack)this.T.clone();
    }

    public Stack getOperandsClone() {
        return (Stack)this.P.clone();
    }

    private boolean bracketedFieldNamesEnabled() {
        return this.Q != null && this.Q.bracketedFieldNamesEnabled();
    }

    private static void collectOperands(Object object, List list) {
        if (object instanceof List) {
            List list2 = (List)object;
            for (int i = 0; i < list2.size(); ++i) {
                Evaluator.collectOperands(list2.get(i), list);
            }
        } else if (object instanceof ExpressionOperand) {
            boolean bl = !list.isEmpty() && ((DocmosisOperand)list.get((int)(list.size() - 1))).collectedFromFunction;
            String string = ((ExpressionOperand)object).getValue();
            if (string.startsWith("[") && string.endsWith("]") && bl) {
                ((DocmosisOperand)list.get((int)(list.size() - 1))).term = ((DocmosisOperand)list.get((int)(list.size() - 1))).term + string;
            } else {
                list.add(new DocmosisOperand(((ExpressionOperand)object).getValue(), false));
            }
        } else if (object instanceof ParsedFunction) {
            ParsedFunction parsedFunction = (ParsedFunction)object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(parsedFunction.getFunction().getName());
            stringBuffer.append('(');
            String[] stringArray = parsedFunction.getArgumentsArray();
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(stringArray[i]);
            }
            stringBuffer.append(')');
            list.add(new DocmosisOperand(stringBuffer.toString(), true));
        } else if (object instanceof ExpressionTree) {
            Evaluator.collectOperands(((ExpressionTree)object).getLeftOperand(), list);
            Evaluator.collectOperands(((ExpressionTree)object).getRightOperand(), list);
        }
    }

    static boolean isBooleanLiteral(String string) {
        return "true".equals(string) || "false".equals(string);
    }

    public static class DocmosisOperand {
        public String term;
        public boolean collectedFromFunction;

        public DocmosisOperand(String string, boolean bl) {
            this.term = string;
            this.collectedFromFunction = bl;
        }

        public String getValue() {
            return this.term;
        }
    }
}

