/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.xml;

import com.docmosis.util.J;
import com.docmosis.util.xml.XMLIndexedAttribute;
import com.docmosis.util.xml.XMLIndexedTag;
import java.util.LinkedHashMap;

public class XMLIndexedTagParser {
    public static XMLIndexedTag parse(J j, long l) throws ParseException {
        XMLIndexedAttribute xMLIndexedAttribute;
        if (j == null) {
            return null;
        }
        if (j.C(0) != '<' || j.C(j.E() - 1) != '>') {
            throw new ParseException("Tag missing \"<\" start or \">\" end : [" + j.toString() + "]");
        }
        if (j.E() < 3) {
            throw new ParseException("Tag is not well formed: too short");
        }
        XMLIndexedTag xMLIndexedTag = new XMLIndexedTag(j.toString());
        xMLIndexedTag.startIdx = l;
        int n = 1;
        if (j.C(1) == '/') {
            xMLIndexedTag.isClose = true;
            ++n;
        }
        n = XMLIndexedTagParser.skipSpaces(j, n);
        xMLIndexedTag.tagName = XMLIndexedTagParser.getName(j, n);
        n += xMLIndexedTag.tagName.length();
        do {
            if (j.C(n = XMLIndexedTagParser.skipSpaces(j, n)) == '>') {
                xMLIndexedTag.endIdx = (long)n + l;
                xMLIndexedTag.remainsOpen = !xMLIndexedTag.isClose;
                break;
            }
            if (j.C(n) == '/') {
                if (n == j.E() - 1) {
                    throw new ParseException("Tag is not well formed: found unexpected /");
                }
                if (j.C(n + 1) != '>') {
                    throw new ParseException("Tag is not well formed: exected /> but got /" + j.C(n + 1));
                }
                xMLIndexedTag.endIdx = (long)(n + 1) + l;
                break;
            }
            if (xMLIndexedTag.attributes == null) {
                xMLIndexedTag.attributes = new LinkedHashMap();
            }
            xMLIndexedAttribute = XMLIndexedTagParser.getAttribute(j, n, l);
            xMLIndexedTag.attributes.put(xMLIndexedAttribute.getName(), xMLIndexedAttribute);
        } while ((n += xMLIndexedAttribute.getLength()) < j.E());
        return xMLIndexedTag;
    }

    private static int skipSpaces(J j, int n) {
        while (Character.isWhitespace(j.C(n))) {
            ++n;
        }
        return n;
    }

    private static String getName(J j, int n) {
        char c;
        int n2 = n;
        while (!Character.isWhitespace(c = j.C(n2)) && c != '/' && c != '>' && c != '=') {
            ++n2;
        }
        return j.B(n, n2 - n);
    }

    private static XMLIndexedAttribute getAttribute(J j, int n, long l) throws ParseException {
        int n2;
        XMLIndexedAttribute xMLIndexedAttribute = new XMLIndexedAttribute();
        xMLIndexedAttribute.keyStartIdx = (long)n + l;
        int n3 = n;
        xMLIndexedAttribute.name = XMLIndexedTagParser.getName(j, n3);
        xMLIndexedAttribute.keyEndIdx = (long)((n3 += xMLIndexedAttribute.name.length()) - 1) + l;
        if (j.C(n3 = XMLIndexedTagParser.skipSpaces(j, n3)) != '=') {
            throw new ParseException("processing attribute name " + xMLIndexedAttribute.name + " expected next char to be =");
        }
        ++n3;
        if (j.C(n3 = XMLIndexedTagParser.skipSpaces(j, n3)) != '\"') {
            throw new ParseException("processing attribute name " + xMLIndexedAttribute.name + " expected next chars to be =\"");
        }
        if ((n2 = j.A("\"", ++n3)) == -1) {
            throw new ParseException("processing attribute name " + xMLIndexedAttribute.name + " and didn't find closing quote");
        }
        xMLIndexedAttribute.value = j.B(n3, n2 - n3);
        xMLIndexedAttribute.valueStartIdx = (long)n3 + l;
        xMLIndexedAttribute.valueEndIdx = (long)(n2 - 1) + l;
        return xMLIndexedAttribute;
    }

    public static class ParseException
    extends Exception {
        public ParseException() {
        }

        public ParseException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public ParseException(String string) {
            super(string);
        }

        public ParseException(Throwable throwable) {
            super(throwable);
        }
    }
}

