/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.xml;

import com.docmosis.util.xml.XMLIndexedAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class XMLIndexedTag
implements Serializable {
    String tagName;
    final String tagText;
    boolean remainsOpen;
    boolean isClose;
    long startIdx;
    long endIdx;
    Map attributes;

    public XMLIndexedTag(String string) {
        this.tagText = string;
    }

    public long getEndIdx() {
        return this.endIdx;
    }

    public boolean isClose() {
        return this.isClose;
    }

    public boolean isRemainsOpen() {
        return this.remainsOpen;
    }

    public String getTagText() {
        return this.tagText;
    }

    public long getStartIdx() {
        return this.startIdx;
    }

    public String getTagName() {
        return this.tagName;
    }

    public XMLIndexedAttribute getAttribute(String string) {
        XMLIndexedAttribute xMLIndexedAttribute = null;
        if (this.attributes != null) {
            xMLIndexedAttribute = (XMLIndexedAttribute)this.attributes.get(string);
        }
        return xMLIndexedAttribute;
    }

    public int getLength() {
        return (int)(this.endIdx - this.startIdx + 1L);
    }

    public boolean isCloseTagFor(XMLIndexedTag xMLIndexedTag) {
        return this.isClose && xMLIndexedTag.remainsOpen && this.tagName.equals(xMLIndexedTag.tagName);
    }

    public String getTagWithoutAttribute(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isClose) {
            stringBuffer.append("</");
        } else {
            stringBuffer.append("<");
        }
        stringBuffer.append(this.tagName);
        if (this.attributes != null && this.attributes.size() > 0) {
            for (XMLIndexedAttribute xMLIndexedAttribute : this.attributes.values()) {
                if (xMLIndexedAttribute == null || xMLIndexedAttribute.getName().equals(string)) continue;
                stringBuffer.append(' ').append(xMLIndexedAttribute.getName()).append("=\"").append(xMLIndexedAttribute.getValue()).append("\"");
            }
        }
        if (this.remainsOpen || this.isClose) {
            stringBuffer.append('>');
        } else {
            stringBuffer.append("/>");
        }
        return stringBuffer.toString();
    }

    public String getTagReplacingAttribute(String string, String string2) {
        return this.getTagReplacingAttributes(new String[][]{{string, string2}});
    }

    public String getTagReplacingAttributes(String[][] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            hashMap.put(stringArray2[0], stringArray2[1]);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isClose) {
            stringBuffer.append("</");
        } else {
            stringBuffer.append("<");
        }
        stringBuffer.append(this.tagName);
        if (this.attributes != null && this.attributes.size() > 0) {
            for (XMLIndexedAttribute object : this.attributes.values()) {
                if (object == null) continue;
                String string = object.getName();
                if (hashMap.containsKey(string)) {
                    String string2 = (String)hashMap.remove(string);
                    stringBuffer.append(' ').append(string).append("=\"").append(string2).append("\"");
                    continue;
                }
                stringBuffer.append(' ').append(object.getName()).append("=\"").append(object.getValue()).append("\"");
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            stringBuffer.append(' ').append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
        }
        if (this.remainsOpen || this.isClose) {
            stringBuffer.append('>');
        } else {
            stringBuffer.append("/>");
        }
        return stringBuffer.toString();
    }

    public String getTagWithDefaultAttributes(XMLIndexedTag xMLIndexedTag, Set set) {
        Map map = xMLIndexedTag.attributes;
        String[][] stringArray = null;
        if (map != null) {
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                if (set == null || set.contains(string)) continue;
                String string2 = ((XMLIndexedAttribute)entry.getValue()).getValue();
                arrayList.add(new String[]{string, string2});
            }
            stringArray = new String[arrayList.size()][];
            arrayList.toArray((T[])stringArray);
        }
        return this.getTagWithDefaultAttributes(stringArray);
    }

    public String getTagWithDefaultAttributes(String[][] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return this.tagText;
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            linkedHashMap.put(stringArray2[0], stringArray2[1]);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isClose) {
            stringBuffer.append("</");
        } else {
            stringBuffer.append("<");
        }
        stringBuffer.append(this.tagName);
        if (this.attributes != null && this.attributes.size() > 0) {
            for (XMLIndexedAttribute object : this.attributes.values()) {
                if (object == null) continue;
                stringBuffer.append(' ').append(object.getName()).append("=\"").append(object.getValue()).append("\"");
                linkedHashMap.remove(object.getName());
            }
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            stringBuffer.append(' ').append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
        }
        if (this.remainsOpen || this.isClose) {
            stringBuffer.append('>');
        } else {
            stringBuffer.append("/>");
        }
        return stringBuffer.toString();
    }
}

