/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.ssl;

import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.ssl.SSLSocketSettings;
import com.docmosis.util.ssl.SSLUtilities;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLServerSocketWrapper {
    private static final Logger A = LogManager.getLogger(SSLServerSocketWrapper.class);

    public static SSLServerSocket create(String string, int n, KeyManagerFactory keyManagerFactory, TrustManagerFactory trustManagerFactory) throws GeneralSecurityException, IOException {
        Object object;
        SSLServerSocketFactory sSLServerSocketFactory;
        TrustManager[] trustManagerArray;
        if (string == null) {
            string = "TLS";
        }
        KeyManager[] keyManagerArray = keyManagerFactory == null ? null : keyManagerFactory.getKeyManagers();
        TrustManager[] trustManagerArray2 = trustManagerArray = trustManagerFactory == null ? null : trustManagerFactory.getTrustManagers();
        if (keyManagerArray == null && trustManagerArray == null) {
            A.info("Using default ssl server socket factory");
            sSLServerSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        } else {
            A.info("Using configured ssl server socket factory");
            object = SSLContext.getInstance(string);
            ((SSLContext)object).init(keyManagerArray, trustManagerArray, new SecureRandom());
            sSLServerSocketFactory = ((SSLContext)object).getServerSocketFactory();
        }
        object = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(n);
        ((SSLServerSocket)object).setUseClientMode(false);
        String string2 = "";
        if (A.isInfoEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = ((SSLServerSocket)object).getEnabledProtocols();
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(stringArray[i]);
            }
            string2 = " (Enabled Protocols:" + stringBuffer.toString() + ")";
            A.info("Secure server socket created on port " + n + string2);
            System.out.println("Secure server socket created on port " + n + string2);
        }
        return object;
    }

    public static SSLServerSocket create(String string, int n, File file, char[] cArray, String string2, String string3) throws GeneralSecurityException, IOException {
        return SSLServerSocketWrapper.create(string, n, file, cArray, string2, string3, null, null, null, null);
    }

    public static SSLServerSocket create(String string, int n, File file, char[] cArray, String string2, String string3, File file2, char[] cArray2, String string4, String string5) throws GeneralSecurityException, IOException {
        Object object;
        KeyManagerFactory keyManagerFactory = null;
        if (file != null) {
            if (string2 == null) {
                string2 = KeyStore.getDefaultType();
            }
            if (string3 == null) {
                string3 = KeyManagerFactory.getDefaultAlgorithm();
            }
            keyManagerFactory = KeyManagerFactory.getInstance(string3);
            object = SSLUtilities.getKeyStore(file, cArray, string2);
            keyManagerFactory.init((KeyStore)object, cArray);
        }
        object = null;
        if (file2 != null) {
            if (string4 == null) {
                string4 = KeyStore.getDefaultType();
            }
            if (string5 == null) {
                string5 = TrustManagerFactory.getDefaultAlgorithm();
            }
            object = TrustManagerFactory.getInstance(string5);
            KeyStore keyStore = SSLUtilities.getKeyStore(file2, cArray2, string4);
            ((TrustManagerFactory)object).init(keyStore);
        }
        return SSLServerSocketWrapper.create(string, n, keyManagerFactory, object);
    }

    public static final SSLServerSocket create(SSLSocketSettings sSLSocketSettings) throws GeneralSecurityException, IOException {
        return SSLServerSocketWrapper.create(sSLSocketSettings.getSslProtocol(), sSLSocketSettings.getPort(), sSLSocketSettings.getKeyStoreFile(), sSLSocketSettings.getKeyStorePw(), sSLSocketSettings.getKeyStoreType(), sSLSocketSettings.getKeyStoreAlg(), sSLSocketSettings.getTrustStoreFile(), sSLSocketSettings.getTrustStorePw(), sSLSocketSettings.getTrustStoreType(), sSLSocketSettings.getTrustStoreAlg());
    }

    public static void main(String[] stringArray) throws Exception {
    }
}

