/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.ssl;

import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.ssl.SSLClientSocketSettings;
import com.docmosis.util.ssl.SSLUtilities;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLClientSocketWrapper {
    private static final Logger A = LogManager.getLogger(SSLClientSocketWrapper.class);

    public static SSLSocket wrap(Socket socket, String string, String string2, int n, KeyManagerFactory keyManagerFactory, TrustManagerFactory trustManagerFactory) throws GeneralSecurityException, IOException {
        if (string == null) {
            string = "TLS";
        }
        SSLContext sSLContext = SSLContext.getInstance(string);
        KeyManager[] keyManagerArray = keyManagerFactory == null ? null : keyManagerFactory.getKeyManagers();
        TrustManager[] trustManagerArray = trustManagerFactory == null ? null : trustManagerFactory.getTrustManagers();
        A.debug("initializing client secure socket with key managers:" + (keyManagerArray == null ? 0 : keyManagerArray.length) + ", trust managers :" + (trustManagerArray == null ? 0 : trustManagerArray.length));
        sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        boolean bl = true;
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, string2, n, true);
        sSLSocket.setUseClientMode(true);
        sSLSocket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

            @Override
            public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
                if (A.isDebugEnabled()) {
                    try {
                        Certificate[] certificateArray = handshakeCompletedEvent.getSession().getPeerCertificates();
                        for (int i = 0; certificateArray != null && i < certificateArray.length; ++i) {
                            A.debug("Connected using peer certificate [" + i + "]:" + certificateArray[i]);
                        }
                    }
                    catch (Exception exception) {
                        A.warn("Unable to list peer certificates used", exception);
                    }
                }
                A.info("secure handshake completed for protocol:" + handshakeCompletedEvent.getSession().getProtocol());
            }
        });
        A.debug("starting handshake");
        sSLSocket.startHandshake();
        return sSLSocket;
    }

    public static SSLSocket wrap(Socket socket, String string, String string2, int n, File file, char[] cArray, String string3, String string4) throws IOException, GeneralSecurityException {
        return SSLClientSocketWrapper.wrap(socket, string, string2, n, null, null, null, null, file, cArray, string3, string4);
    }

    public static SSLSocket wrap(Socket socket, String string, String string2, int n, File file, char[] cArray, String string3, String string4, File file2, char[] cArray2, String string5, String string6) throws IOException, GeneralSecurityException {
        Object object;
        KeyManagerFactory keyManagerFactory = null;
        if (file != null) {
            if (string3 == null) {
                string3 = KeyStore.getDefaultType();
            }
            if (string4 == null) {
                string4 = KeyManagerFactory.getDefaultAlgorithm();
            }
            keyManagerFactory = KeyManagerFactory.getInstance(string4);
            object = SSLUtilities.getKeyStore(file, cArray, string3);
            keyManagerFactory.init((KeyStore)object, cArray);
        }
        object = null;
        if (file2 != null) {
            if (string5 == null) {
                string5 = KeyStore.getDefaultType();
            }
            if (string6 == null) {
                string6 = TrustManagerFactory.getDefaultAlgorithm();
            }
            object = TrustManagerFactory.getInstance(string6);
            KeyStore keyStore = SSLUtilities.getKeyStore(file2, cArray2, string5);
            ((TrustManagerFactory)object).init(keyStore);
        }
        return SSLClientSocketWrapper.wrap(socket, string, string2, n, keyManagerFactory, (TrustManagerFactory)object);
    }

    public static SSLSocket wrap(Socket socket, SSLClientSocketSettings sSLClientSocketSettings) throws IOException, GeneralSecurityException {
        return SSLClientSocketWrapper.wrap(socket, sSLClientSocketSettings.getSslProtocol(), sSLClientSocketSettings.getHostname(), sSLClientSocketSettings.getPort(), sSLClientSocketSettings.getKeyStoreFile(), sSLClientSocketSettings.getKeyStorePw(), sSLClientSocketSettings.getKeyStoreType(), sSLClientSocketSettings.getKeyStoreAlg(), sSLClientSocketSettings.getTrustStoreFile(), sSLClientSocketSettings.getTrustStorePw(), sSLClientSocketSettings.getTrustStoreType(), sSLClientSocketSettings.getTrustStoreAlg());
    }

    public static void main(String[] stringArray) throws Exception {
    }
}

