/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.ris;

import com.docmosis.util.FileUtilities;
import com.docmosis.util.NumberUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.ris.RepeatableFileReader;
import java.io.CharArrayReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;

public class RepeatableReader
extends Reader {
    private static final Logger F = LogManager.getLogger(RepeatableReader.class);
    private Reader E;
    private long B;
    private long A;
    private long G;
    private int D;
    private File C;

    private RepeatableReader(Reader reader, long l, long l2, int n) throws IOException {
        this.A = l2;
        this.B = l;
        this.D = n;
        this.G = l2 - l + 1L;
        if (reader instanceof RepeatableReader) {
            RepeatableReader repeatableReader = (RepeatableReader)reader;
            if (repeatableReader.isMemoryMapped()) {
                this.E = new AccessibleCharArrayReader((AccessibleCharArrayReader)repeatableReader.E, l, (int)this.G);
            } else {
                RepeatableFileReader repeatableFileReader = (RepeatableFileReader)repeatableReader.E;
                if (this.G <= (long)this.D) {
                    int n2;
                    char[] cArray = new char[(int)this.G];
                    int n3 = 0;
                    while ((n2 = repeatableReader.read(cArray, n3, (int)this.G - n3)) > 0) {
                        n3 += n2;
                    }
                    this.E = new AccessibleCharArrayReader(cArray, l);
                } else {
                    this.E = new RepeatableFileReader(repeatableFileReader, l, l2);
                }
            }
        } else if (this.G <= (long)this.D) {
            int n4;
            char[] cArray = new char[(int)this.G];
            int n5 = 0;
            while ((n4 = reader.read(cArray, n5, (int)this.G - n5)) > 0) {
                n5 += n4;
            }
            this.E = new AccessibleCharArrayReader(cArray, l);
        } else {
            this.C = FileUtilities.createTempFile("dm_", "rr1");
            FileUtilities.storeToFile(reader, this.C, this.G);
            if (this.C.length() <= 0L) {
                throw new EOFException("InputStream received is empty.");
            }
            this.E = new RepeatableFileReader(this.C, l, l2);
        }
    }

    public static RepeatableReader getReader(Reader reader, long l, long l2, int n) throws IOException {
        if (reader instanceof RepeatableReader) {
            RepeatableReader repeatableReader = (RepeatableReader)reader;
            if (l < repeatableReader.B || l > repeatableReader.A) {
                throw new IllegalArgumentException("logical start is outside current " + repeatableReader.getClass().getName());
            }
            if (l2 < repeatableReader.B || l2 > repeatableReader.A) {
                throw new IllegalArgumentException("logical end is outside current " + repeatableReader.getClass().getName());
            }
        }
        return new RepeatableReader(reader, l, l2, n);
    }

    public boolean isMemoryMapped() {
        return this.E instanceof CharArrayReader;
    }

    @Override
    public int read() throws IOException {
        return this.E.read();
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        return this.E.read(cArray, n, n2);
    }

    @Override
    public int read(char[] cArray) throws IOException {
        return this.E.read(cArray);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.E.reset();
    }

    @Override
    public void close() throws IOException {
        this.E.close();
        if (this.C != null && !this.C.delete()) {
            F.warn("Could not delete temp file");
        }
    }

    @Override
    public long skip(long l) throws IOException {
        return this.E.skip(l);
    }

    protected Reader getDelegate() {
        return this.E;
    }

    public static interface LinkedReader {
        public long getLogicalStartIndex();

        public char[] getBuffer() throws IOException;

        public LinkedReader getAncestor();
    }

    public static class AccessibleCharArrayReader
    extends CharArrayReader
    implements LinkedReader {
        private long G;
        private LinkedReader H;

        public AccessibleCharArrayReader(char[] cArray, long l) {
            super(cArray);
            this.G = l;
        }

        public AccessibleCharArrayReader(AccessibleCharArrayReader accessibleCharArrayReader, long l, int n) throws IOException {
            super(accessibleCharArrayReader.getBuffer(), AccessibleCharArrayReader.getOffset(accessibleCharArrayReader, l), n);
            this.G = l;
            this.H = accessibleCharArrayReader.getAncestor() != null ? accessibleCharArrayReader.getAncestor() : accessibleCharArrayReader;
            accessibleCharArrayReader.skip(n);
        }

        @Override
        public LinkedReader getAncestor() {
            return this.H;
        }

        @Override
        public char[] getBuffer() {
            return this.buf;
        }

        @Override
        public long getLogicalStartIndex() {
            return this.G;
        }

        private static int getOffset(LinkedReader linkedReader, long l) {
            if (linkedReader.getAncestor() != null) {
                linkedReader = linkedReader.getAncestor();
            }
            return NumberUtilities.longToInt(l - linkedReader.getLogicalStartIndex());
        }
    }
}

