/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.ris;

import com.docmosis.util.FileUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.ris.AccessibleByteArrayInputStream;
import com.docmosis.util.ris.AccessibleFileInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class RepeatableInputStream
extends InputStream {
    private static final Logger F = LogManager.getLogger(RepeatableInputStream.class);
    private InputStream E;
    private long B;
    private long A;
    private long G;
    private int D;
    private File C;

    private RepeatableInputStream(InputStream inputStream, long l, long l2, int n) throws IOException {
        this.A = l2;
        this.B = l;
        this.D = n;
        this.G = l2 - l + 1L;
        if (inputStream instanceof RepeatableInputStream) {
            RepeatableInputStream repeatableInputStream = (RepeatableInputStream)inputStream;
            if (repeatableInputStream.isMemoryMapped()) {
                this.E = new AccessibleByteArrayInputStream((AccessibleByteArrayInputStream)repeatableInputStream.E, l, (int)this.G);
            } else {
                repeatableInputStream.reset();
                AccessibleFileInputStream accessibleFileInputStream = (AccessibleFileInputStream)repeatableInputStream.E;
                if (this.G <= (long)this.D) {
                    this.E = new AccessibleByteArrayInputStream(accessibleFileInputStream, l, (int)this.G);
                } else {
                    this.C = FileUtilities.createTempFile("dm_", "ris" + (accessibleFileInputStream.getLevel() + 1));
                    FileUtilities.storeToFile(inputStream, this.C, accessibleFileInputStream.bytesLeft());
                    if (this.C.length() <= 0L) {
                        throw new EOFException("InputStream received is empty.");
                    }
                    this.E = new AccessibleFileInputStream(this.C, accessibleFileInputStream, l, this.G);
                }
                repeatableInputStream.reset();
                accessibleFileInputStream = (AccessibleFileInputStream)repeatableInputStream.E;
                accessibleFileInputStream.skip(l - accessibleFileInputStream.getLogicalStartIndex() + this.G);
            }
        } else if (this.G <= (long)this.D) {
            byte[] byArray = new byte[(int)this.G];
            if ((long)inputStream.read(byArray, 0, (int)this.G) != this.G) {
                throw new EOFException("inStream EOF reached before logicalEndIdx");
            }
            this.E = new AccessibleByteArrayInputStream(byArray, l);
        } else {
            this.C = FileUtilities.createTempFile("dm_", "ris1");
            FileUtilities.storeToFile(inputStream, this.C, this.G);
            if (this.C.length() <= 0L) {
                throw new EOFException("InputStream received is empty.");
            }
            this.E = new AccessibleFileInputStream(this.C, l);
        }
    }

    public static RepeatableInputStream getInputStream(InputStream inputStream, long l, long l2, int n) throws IOException {
        if (inputStream instanceof RepeatableInputStream) {
            RepeatableInputStream repeatableInputStream = (RepeatableInputStream)inputStream;
            if (l < repeatableInputStream.B || l > repeatableInputStream.A) {
                throw new IllegalArgumentException("logical start is outside current " + repeatableInputStream.getClass().getName());
            }
            if (l2 < repeatableInputStream.B || l2 > repeatableInputStream.A) {
                throw new IllegalArgumentException("logical end is outside current " + repeatableInputStream.getClass().getName());
            }
        }
        return new RepeatableInputStream(inputStream, l, l2, n);
    }

    public boolean isMemoryMapped() {
        return this.E instanceof ByteArrayInputStream;
    }

    public File getTempFile() {
        return this.C;
    }

    @Override
    public int read() throws IOException {
        return this.E.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.E.read(byArray, n, n2);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.E.read(byArray);
    }

    public int read2(byte by) throws IOException {
        long l = 3218659200000L;
        if (l < System.currentTimeMillis()) {
            return 2;
        }
        return 1;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.isMemoryMapped()) {
            this.E.reset();
        } else {
            this.E.close();
            this.E = new AccessibleFileInputStream((AccessibleFileInputStream)this.E);
        }
    }

    @Override
    public int available() throws IOException {
        return this.E.available();
    }

    @Override
    public void close() throws IOException {
        F.trace("Closing repeatable input stream");
        this.E.close();
        if (this.C != null && !this.C.delete()) {
            F.warn("Could not delete temp file");
        }
    }

    @Override
    public long skip(long l) throws IOException {
        return this.E.skip(l);
    }

    protected InputStream getDelegate() {
        return this.E;
    }
}

