/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.ris;

import com.docmosis.util.FileUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;

public class RepeatableFileReader
extends Reader {
    Reader delegate;
    File file;
    long baseLogicalStartIdx;
    long length;
    long initialOffset;
    long readSoFar;

    public RepeatableFileReader(File file, long l, long l2) throws IOException {
        this.file = file;
        this.baseLogicalStartIdx = l;
        this.length = l2 - l + 1L;
        this.buildDelegate();
    }

    public RepeatableFileReader(RepeatableFileReader repeatableFileReader, long l, long l2) throws IOException {
        this.file = repeatableFileReader.file;
        this.baseLogicalStartIdx = repeatableFileReader.baseLogicalStartIdx;
        this.length = l2 - l + 1L;
        this.initialOffset = l - this.baseLogicalStartIdx;
        this.buildDelegate();
        repeatableFileReader.skip(this.length);
    }

    @Override
    public void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = Math.min(n2, (int)(this.length - this.readSoFar));
        if (n3 == 0) {
            return -1;
        }
        int n4 = this.delegate.read(cArray, n, n3);
        if (n4 == -1) {
            return -1;
        }
        this.readSoFar += (long)n4;
        return n4;
    }

    @Override
    public int read() throws IOException {
        if (this.readSoFar >= this.length) {
            return -1;
        }
        int n = this.delegate.read();
        if (n != -1) {
            ++this.readSoFar;
        }
        return n;
    }

    @Override
    public int read(CharBuffer charBuffer) throws IOException {
        throw new IOException("read(CharBuffer) not supported");
    }

    @Override
    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    @Override
    public void reset() throws IOException {
        this.close();
        this.buildDelegate();
    }

    @Override
    public long skip(long l) throws IOException {
        return super.skip(l);
    }

    private void buildDelegate() throws IOException {
        FileUtilities.close(this.delegate);
        this.delegate = new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8");
        this.readSoFar = 0L;
        this.delegate.skip(this.initialOffset);
        this.readSoFar = 0L;
    }

    public static void main(String[] stringArray) throws IOException {
    }
}

