/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.pipeline.impl;

import com.docmosis.util.pipeline.ChannelDataTask;
import com.docmosis.util.pipeline.DataManipulatorFactory;
import com.docmosis.util.pipeline.DataTask;
import com.docmosis.util.pipeline.impl.BasicChannelDataWorker;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipChannelDataWorker
extends BasicChannelDataWorker {
    private final byte[] P = new byte[1024];

    public ZipChannelDataWorker(DataManipulatorFactory dataManipulatorFactory) {
        super(dataManipulatorFactory);
    }

    @Override
    protected void processTask(DataTask dataTask) throws IOException {
        ZipEntry zipEntry;
        ChannelDataTask channelDataTask = (ChannelDataTask)dataTask;
        InputStream inputStream = Channels.newInputStream(channelDataTask.getInputChannel());
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipOutputStream zipOutputStream = new ZipOutputStream(Channels.newOutputStream(channelDataTask.getOutputChannel()));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            this.processZipEntry2(zipEntry, zipInputStream, zipOutputStream);
        }
        zipOutputStream.finish();
    }

    protected void processZipEntry2(ZipEntry zipEntry, ZipInputStream zipInputStream, ZipOutputStream zipOutputStream) throws IOException {
        int n;
        long l = 0L;
        System.out.println("entry:" + zipEntry.getSize() + " " + zipEntry.getName());
        zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
        while ((n = zipInputStream.read(this.P)) != -1) {
            zipOutputStream.write(this.P, 0, n);
            l += (long)n;
        }
        zipOutputStream.closeEntry();
    }
}

