/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.pipeline.impl;

import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.pipeline.DataPipeline;
import com.docmosis.util.pipeline.DataTask;
import com.docmosis.util.pipeline.DataWorker;
import com.docmosis.util.pipeline.InvalidDataTaskException;
import com.docmosis.util.pipeline.PipelineException;
import com.docmosis.util.pipeline.StreamDataTask;
import com.docmosis.util.pipeline.impl.BasicStreamDataTask;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StreamDataPipeline
implements DataPipeline {
    private static final Logger B = LogManager.getLogger(StreamDataPipeline.class);
    private List A = new ArrayList();

    @Override
    public void addDataWorker(DataWorker dataWorker) throws PipelineException, IOException {
        if (dataWorker == null) {
            throw new PipelineException("null dataworker given");
        }
        this.A.add(dataWorker);
    }

    @Override
    public void process(DataTask dataTask) throws PipelineException, IOException {
        if (dataTask == null) {
            throw new PipelineException("null task given");
        }
        if (!(dataTask instanceof StreamDataTask)) {
            throw new PipelineException("Can only process StreamDataTask tasks");
        }
        try {
            this.connectPipes((StreamDataTask)dataTask);
        }
        catch (InvalidDataTaskException invalidDataTaskException) {
            this.shutdown();
            throw new PipelineException("Unable to task the dataworker ", invalidDataTaskException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connectPipes(StreamDataTask streamDataTask) throws PipelineException, IOException, InvalidDataTaskException {
        Object object;
        BasicStreamDataTask basicStreamDataTask;
        if (this.A.isEmpty()) {
            throw new PipelineException("There must be at least one worker for this pipeline");
        }
        ArrayList<BasicStreamDataTask> arrayList = new ArrayList<BasicStreamDataTask>();
        InputStream inputStream = streamDataTask.getInputStream();
        OutputStream outputStream = streamDataTask.getOutputStream();
        int n = this.A.size();
        StreamPipe streamPipe = null;
        for (int i = 0; i < n - 1; ++i) {
            streamPipe = this.getPipe();
            outputStream = streamPipe.sink();
            basicStreamDataTask = new BasicStreamDataTask(inputStream, outputStream);
            object = (DataWorker)this.A.get(i);
            object.addTask(basicStreamDataTask);
            arrayList.add(basicStreamDataTask);
            inputStream = streamPipe.source();
        }
        DataWorker dataWorker = (DataWorker)this.A.get(this.A.size() - 1);
        basicStreamDataTask = new BasicStreamDataTask(inputStream, streamDataTask.getOutputStream());
        dataWorker.addTask(basicStreamDataTask);
        arrayList.add(basicStreamDataTask);
        try {
            object = arrayList.iterator();
            while (object.hasNext()) {
                DataTask dataTask;
                DataTask dataTask2 = dataTask = (DataTask)object.next();
                synchronized (dataTask2) {
                    if (!dataTask.isComplete()) {
                        dataTask.wait();
                    }
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private StreamPipe getPipe() throws IOException {
        return StreamPipe.open();
    }

    @Override
    public void shutdown() {
        Iterator iterator = this.A.iterator();
        while (iterator.hasNext()) {
            DataWorker dataWorker = (DataWorker)iterator.next();
            if (dataWorker != null) {
                try {
                    dataWorker.shutdown();
                }
                catch (Exception exception) {
                    B.error("Error during shutdown", exception);
                }
            }
            iterator.remove();
        }
    }

    public static class StreamPipe {
        PipedInputStream source = new PipedInputStream();
        PipedOutputStream sink = new PipedOutputStream();

        private StreamPipe() throws IOException {
            this.sink.connect(this.source);
        }

        public PipedInputStream source() {
            return this.source;
        }

        public PipedOutputStream sink() {
            return this.sink;
        }

        public static StreamPipe open() throws IOException {
            return new StreamPipe();
        }

        public void close() throws IOException {
            this.source.close();
            this.sink.close();
        }
    }
}

