/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.pipeline.impl;

import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.pipeline.DataWorker;
import com.docmosis.util.pipeline.impl.DataWorkerPoolException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class DataWorkerPool {
    private static final Logger C = LogManager.getLogger(DataWorkerPool.class);
    private final Class A;
    private final int E;
    private final ArrayList D;
    private final ArrayList B;

    public DataWorkerPool(Class clazz, int n, int n2) throws DataWorkerPoolException, IllegalArgumentException {
        if (n > n2) {
            throw new IllegalArgumentException("Initial size must not be larger than max size");
        }
        this.A = clazz;
        this.E = n2;
        this.D = new ArrayList();
        this.B = new ArrayList();
        for (int i = 0; i < n; ++i) {
            this.D.add(this.createInstance());
        }
    }

    public synchronized DataWorker getDataWorker() throws DataWorkerPoolException {
        DataWorker dataWorker = null;
        boolean bl = false;
        try {
            while (this.D.size() == 0 && !bl) {
                if (this.B.size() < this.E) {
                    dataWorker = this.createInstance();
                    bl = true;
                    continue;
                }
                this.wait();
            }
            if (!bl) {
                dataWorker = (DataWorker)this.D.remove(0);
            }
            this.B.add(dataWorker);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return dataWorker;
    }

    public synchronized void returnDataWorker(DataWorker dataWorker) {
        boolean bl = this.B.remove(dataWorker);
        if (bl) {
            this.D.add(dataWorker);
        }
        this.notify();
    }

    public synchronized void shutdown() {
        this.shutdownInstances(this.D);
        this.shutdownInstances(this.B);
    }

    private void shutdownInstances(List list) {
        if (list != null) {
            for (DataWorker dataWorker : list) {
                if (dataWorker == null) continue;
                dataWorker.shutdown();
            }
            list.clear();
        }
    }

    private DataWorker createInstance() throws DataWorkerPoolException {
        if (C.isDebugEnabled()) {
            C.debug("Creating a new data worker instance of type: " + this.A.getName());
        }
        DataWorker dataWorker = null;
        try {
            dataWorker = (DataWorker)this.A.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new DataWorkerPoolException("Error creating new data worker instance", noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new DataWorkerPoolException("Error creating new data worker instance", invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DataWorkerPoolException("Error creating new data worker instance", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new DataWorkerPoolException("Error creating new data worker instance", instantiationException);
        }
        return dataWorker;
    }
}

