/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.pipeline.impl;

import com.docmosis.util.DMProperties;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.pipeline.ChannelDataTask;
import com.docmosis.util.pipeline.DataPipeline;
import com.docmosis.util.pipeline.DataTask;
import com.docmosis.util.pipeline.DataWorker;
import com.docmosis.util.pipeline.InvalidDataTaskException;
import com.docmosis.util.pipeline.PipelineException;
import com.docmosis.util.pipeline.impl.BasicChannelDataTask;
import com.docmosis.util.pipeline.impl.IOPiper;
import java.io.IOException;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ChannelDataPipeline
implements DataPipeline {
    private static final Logger E = LogManager.getLogger(ChannelDataPipeline.class);
    private static final int G = DMProperties.getInt("docmosis.stream.buffer.size");
    private final int H;
    private List D = new ArrayList();
    private IOPiper F;
    private IOPiper C;

    public ChannelDataPipeline() {
        this(G);
    }

    public ChannelDataPipeline(int n) {
        this.H = n;
    }

    @Override
    public void addDataWorker(DataWorker dataWorker) throws PipelineException, IOException {
        if (dataWorker == null) {
            throw new PipelineException("null dataworker given");
        }
        this.D.add(dataWorker);
    }

    @Override
    public void process(DataTask dataTask) throws PipelineException, IOException {
        if (dataTask == null) {
            throw new PipelineException("null task given");
        }
        try {
            this.connectPipes((ChannelDataTask)dataTask);
        }
        catch (InvalidDataTaskException invalidDataTaskException) {
            this.shutdown();
            throw new PipelineException("Unable to task the dataworker ", invalidDataTaskException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectPipes(ChannelDataTask channelDataTask) throws PipelineException, IOException, InvalidDataTaskException {
        Object object;
        BasicChannelDataTask basicChannelDataTask;
        if (this.D.isEmpty()) {
            throw new PipelineException("There must be at least one worker for this pipeline");
        }
        ArrayList<BasicChannelDataTask> arrayList = new ArrayList<BasicChannelDataTask>();
        ReadableByteChannel readableByteChannel = channelDataTask.getInputChannel();
        WritableByteChannel writableByteChannel = channelDataTask.getOutputChannel();
        if (!(readableByteChannel instanceof SelectableChannel)) {
            Pipe pipe = this.getPipe();
            this.F = new IOPiper(readableByteChannel, pipe.sink(), this.H);
            readableByteChannel = pipe.source();
        }
        int n = this.D.size();
        Pipe pipe = null;
        for (int i = 0; i < n - 1; ++i) {
            pipe = this.getPipe();
            writableByteChannel = pipe.sink();
            basicChannelDataTask = new BasicChannelDataTask(readableByteChannel, writableByteChannel);
            object = (DataWorker)this.D.get(i);
            object.addTask(basicChannelDataTask);
            arrayList.add(basicChannelDataTask);
            readableByteChannel = pipe.source();
        }
        writableByteChannel = channelDataTask.getOutputChannel();
        if (!(writableByteChannel instanceof SelectableChannel)) {
            pipe = this.getPipe();
            this.C = new IOPiper(pipe.source(), writableByteChannel, this.H);
            writableByteChannel = pipe.sink();
        }
        DataWorker dataWorker = (DataWorker)this.D.get(this.D.size() - 1);
        basicChannelDataTask = new BasicChannelDataTask(readableByteChannel, writableByteChannel);
        dataWorker.addTask(basicChannelDataTask);
        arrayList.add(basicChannelDataTask);
        object = basicChannelDataTask;
        synchronized (object) {
            try {
                E.debug("WAITING");
                while (!basicChannelDataTask.isComplete()) {
                    basicChannelDataTask.wait();
                }
                E.debug("FINISHED");
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private Pipe getPipe() throws IOException {
        Pipe pipe = Pipe.open();
        return pipe;
    }

    @Override
    public void shutdown() {
        Iterator iterator = this.D.iterator();
        while (iterator.hasNext()) {
            DataWorker dataWorker = (DataWorker)iterator.next();
            if (dataWorker != null) {
                try {
                    dataWorker.shutdown();
                }
                catch (Exception exception) {
                    E.error("Error during shutdown", exception);
                }
            }
            iterator.remove();
        }
        IOPiper.shutdown(this.F);
        this.F = null;
        IOPiper.shutdown(this.C);
        this.C = null;
    }
}

