/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.pipeline.impl;

import com.docmosis.util.pipeline.DataTask;
import com.docmosis.util.pipeline.StreamDataTask;
import com.docmosis.util.pipeline.TaskException;
import com.docmosis.util.pipeline.impl.BasicStreamDataWorker;
import com.docmosis.util.pipeline.impl.NonHangingZipInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class BasicZipStreamDataWorker
extends BasicStreamDataWorker {
    @Override
    protected void processTask(DataTask dataTask) throws IOException, TaskException {
        ZipEntry zipEntry;
        StreamDataTask streamDataTask = (StreamDataTask)dataTask;
        InputStream inputStream = streamDataTask.getInputStream();
        NonHangingZipInputStream nonHangingZipInputStream = new NonHangingZipInputStream(inputStream);
        ZipOutputStream zipOutputStream = new ZipOutputStream(streamDataTask.getOutputStream());
        while ((zipEntry = nonHangingZipInputStream.getNextEntry()) != null) {
            this.processEntry(zipEntry, nonHangingZipInputStream, zipOutputStream);
            nonHangingZipInputStream.closeEntry();
        }
        nonHangingZipInputStream.close();
        zipOutputStream.finish();
    }

    protected void processEntry(ZipEntry zipEntry, ZipInputStream zipInputStream, ZipOutputStream zipOutputStream) throws IOException, TaskException {
        this.duplicateEntry(zipEntry, zipInputStream, zipOutputStream);
    }

    protected void duplicateEntry(ZipEntry zipEntry, ZipInputStream zipInputStream, ZipOutputStream zipOutputStream) throws IOException {
        int n;
        zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
        while ((n = zipInputStream.read(this.buffer)) != -1) {
            zipOutputStream.write(this.buffer, 0, n);
        }
        zipOutputStream.closeEntry();
    }
}

