/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.pipeline.impl;

import com.docmosis.util.DMProperties;
import com.docmosis.util.I;
import com.docmosis.util.pipeline.DataTask;
import com.docmosis.util.pipeline.InvalidDataTaskException;
import com.docmosis.util.pipeline.StreamDataTask;
import com.docmosis.util.pipeline.TaskException;
import com.docmosis.util.pipeline.impl.AbstractDataWorker;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class BasicStreamDataWorker
extends AbstractDataWorker {
    private static final int E = DMProperties.getInt("docmosis.stream.buffer.size");
    protected final byte[] buffer = new byte[E];

    @Override
    protected void validateDataTask(DataTask dataTask) throws InvalidDataTaskException {
        if (!(dataTask instanceof StreamDataTask)) {
            throw new InvalidDataTaskException("The data task INPUT channel must be a StreamDataTask");
        }
    }

    @Override
    protected void processTask(DataTask dataTask) throws IOException, TaskException {
        int n;
        StreamDataTask streamDataTask = (StreamDataTask)dataTask;
        InputStream inputStream = streamDataTask.getInputStream();
        OutputStream outputStream = streamDataTask.getOutputStream();
        String string = this.getModuleTimingId();
        I i = null;
        boolean bl = true;
        while ((n = inputStream.read(this.buffer)) != -1) {
            if (bl) {
                i = I.B(string, this.moduleTiming);
                bl = false;
            }
            outputStream.write(this.buffer, 0, n);
        }
        I.A(string, i);
    }

    @Override
    protected void closePipes(DataTask dataTask) {
        StreamDataTask streamDataTask = (StreamDataTask)dataTask;
        BasicStreamDataWorker.closeIfPipe(streamDataTask.getOutputStream());
        BasicStreamDataWorker.closeIfPipe(streamDataTask.getInputStream());
    }

    private static void closeIfPipe(InputStream inputStream) {
        if (inputStream != null && inputStream instanceof PipedInputStream) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static void closeIfPipe(OutputStream outputStream) {
        if (outputStream != null && outputStream instanceof PipedOutputStream) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

