/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.pipeline.impl;

import com.docmosis.util.pipeline.ChannelDataTask;
import com.docmosis.util.pipeline.DataManipulator;
import com.docmosis.util.pipeline.DataManipulatorFactory;
import com.docmosis.util.pipeline.DataTask;
import com.docmosis.util.pipeline.InvalidDataTaskException;
import com.docmosis.util.pipeline.impl.AbstractDataWorker;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;

public class BasicChannelDataWorker
extends AbstractDataWorker {
    private DataManipulatorFactory O;

    public BasicChannelDataWorker(DataManipulatorFactory dataManipulatorFactory) {
        this.O = dataManipulatorFactory;
    }

    @Override
    public void addTask(DataTask dataTask) throws InvalidDataTaskException, IOException {
        if (this.O != null) {
            ChannelDataTask channelDataTask = (ChannelDataTask)dataTask;
            DataManipulator dataManipulator = this.O.getDataManipulator();
            dataManipulator.setOutputChannel(channelDataTask.getOutputChannel());
            channelDataTask.setDataManipulator(dataManipulator);
        }
        super.addTask(dataTask);
    }

    @Override
    protected void validateDataTask(DataTask dataTask) throws InvalidDataTaskException {
        if (!(dataTask instanceof ChannelDataTask)) {
            throw new InvalidDataTaskException("The data task INPUT channel must be a ChannelDataTask");
        }
        ChannelDataTask channelDataTask = (ChannelDataTask)dataTask;
        if (!(channelDataTask.getInputChannel() instanceof SelectableChannel)) {
            throw new InvalidDataTaskException("The data task INPUT channel must be a SelectableChannel");
        }
        if (!(channelDataTask.getOutputChannel() instanceof SelectableChannel)) {
            throw new InvalidDataTaskException("The data task OUTPUT channel must be a SelectableChannel");
        }
    }

    @Override
    protected void processTask(DataTask dataTask) throws IOException {
        int n;
        ChannelDataTask channelDataTask = (ChannelDataTask)dataTask;
        InputStream inputStream = Channels.newInputStream(channelDataTask.getInputChannel());
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) > 0) {
            channelDataTask.getDataManipulator().manipulate(ByteBuffer.wrap(byArray, 0, n));
        }
    }

    @Override
    protected void closePipes(DataTask dataTask) {
        ChannelDataTask channelDataTask = (ChannelDataTask)dataTask;
        BasicChannelDataWorker.closeIfPipe(channelDataTask.getInputChannel());
        BasicChannelDataWorker.closeIfPipe(channelDataTask.getOutputChannel());
    }

    private static void closeIfPipe(Channel channel) {
        if (channel != null && (channel instanceof Pipe.SinkChannel || channel instanceof Pipe.SourceChannel)) {
            try {
                channel.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

