/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.pipeline.impl;

import com.docmosis.util.DMProperties;
import com.docmosis.util.ExceptionUtils;
import com.docmosis.util.I;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.pipeline.DataTask;
import com.docmosis.util.pipeline.DataWorker;
import com.docmosis.util.pipeline.InvalidDataTaskException;
import com.docmosis.util.pipeline.TaskException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDataWorker
implements DataWorker,
Runnable {
    private static final Logger A = LogManager.getLogger(AbstractDataWorker.class);
    static final long WORKER_SHUTDOWN_GRACE_PERIOD = DMProperties.getLong("docmosis.data.worker.shutdown.graceperiod", 15000L);
    private static final long D = 500L;
    private List B = new ArrayList();
    protected Thread runningThread = new Thread(this);
    boolean running;
    protected I moduleTiming;
    boolean started;
    private boolean C;

    public AbstractDataWorker() {
        this.runningThread.setName(this.getThreadName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTask(DataTask dataTask) throws InvalidDataTaskException, IOException {
        this.validateDataTask(dataTask);
        AbstractDataWorker abstractDataWorker = this;
        synchronized (abstractDataWorker) {
            if (!this.started) {
                this.runningThread.start();
                this.started = true;
            }
            this.B.add(dataTask);
            this.notify();
        }
    }

    protected abstract void validateDataTask(DataTask var1) throws InvalidDataTaskException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (this.running) {
            this.C = false;
            this.running = false;
            AbstractDataWorker abstractDataWorker = this;
            synchronized (abstractDataWorker) {
                this.notify();
            }
            int n = (int)(WORKER_SHUTDOWN_GRACE_PERIOD / 500L);
            for (int i = 0; !this.C && i < n; ++i) {
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    i = n;
                    break;
                }
            }
        }
        AbstractDataWorker abstractDataWorker = this;
        synchronized (abstractDataWorker) {
            if (this.runningThread != null) {
                this.runningThread.interrupt();
                this.runningThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        try {
            while (this.running) {
                try {
                    Object object;
                    DataTask dataTask = null;
                    Object object2 = this;
                    synchronized (object2) {
                        if (this.B.isEmpty()) {
                            this.wait();
                        }
                        if (!this.running) {
                            break;
                        }
                        dataTask = (DataTask)this.B.get(0);
                    }
                    try {
                        object2 = this.getModuleTimingId();
                        object = I.B((String)object2, this.moduleTiming);
                        this.processTask(dataTask);
                        I.A((String)object2, (I)object);
                    }
                    catch (IOException iOException) {
                        object = new StringBuffer();
                        if (iOException.getMessage() != null) {
                            ((StringBuffer)object).append(iOException.getMessage()).append(" (IOException)");
                        } else {
                            ((StringBuffer)object).append("IOException");
                        }
                        dataTask.setFailed(((StringBuffer)object).toString(), iOException);
                    }
                    catch (TaskException taskException) {
                        dataTask.setFailed("Task failed:" + (taskException.getMessage() == null ? ExceptionUtils.getUnqualifiedExceptionClassName(taskException) : taskException.getMessage()), taskException);
                    }
                    catch (RuntimeException runtimeException) {
                        dataTask.setFailed("Task failed:" + (runtimeException.getMessage() == null ? ExceptionUtils.getUnqualifiedExceptionClassName(runtimeException) : runtimeException.getMessage()), runtimeException);
                    }
                    catch (Throwable throwable) {
                        A.error("An unexpected Error occurred", throwable);
                        dataTask.setFailed("Task failed:" + (throwable.getMessage() == null ? ExceptionUtils.getUnqualifiedExceptionClassName(throwable) : throwable.getMessage()), throwable);
                    }
                    finally {
                        object2 = this;
                        synchronized (object2) {
                            this.B.remove(dataTask);
                        }
                    }
                    try {
                        this.closePipes(dataTask);
                    }
                    catch (Throwable throwable) {
                        A.warn("An unexpected Error occurred closing task connections", throwable);
                    }
                    object2 = dataTask;
                    synchronized (object2) {
                        dataTask.setComplete(true);
                        dataTask.notify();
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.running = false;
                }
                catch (Throwable throwable) {
                    A.error("An unexpected Error occurred", throwable);
                }
            }
        }
        finally {
            this.C = true;
            this.running = false;
        }
    }

    public I getModuleTiming() {
        return this.moduleTiming;
    }

    @Override
    public void setModuleTiming(I i) {
        this.moduleTiming = i;
    }

    protected String getModuleTimingId() {
        return this.getShortClassName();
    }

    private String getShortClassName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n != -1 && n < string.length() - 2) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static long getTime() {
        return 6437318400000L;
    }

    protected String getThreadName() {
        return this.getShortClassName() + this.hashCode();
    }

    protected abstract void processTask(DataTask var1) throws IOException, TaskException;

    protected abstract void closePipes(DataTask var1);
}

