/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.openoffice;

import com.docmosis.util.DMProperties;
import com.docmosis.util.NativeLibraryLoaderUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.File;

public class OpenOfficeLibraryLoader {
    private static final Logger B = LogManager.getLogger(OpenOfficeLibraryLoader.class);
    private static final boolean A = DMProperties.getBoolean("docmosis.openoffice.libraries.doLoad", false);

    public static void loadNativeLibraries() {
        File[] fileArray = NativeLibraryLoaderUtilities.getOONativeLibraries();
        if (B.isDebugEnabled()) {
            B.debug("Loading native libraries");
        }
        int n = 0;
        int n2 = 0;
        if (fileArray != null) {
            try {
                for (n2 = 0; n2 < fileArray.length; ++n2) {
                    System.load(fileArray[n2].getAbsolutePath());
                    ++n;
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if ("64".equals(System.getProperty("sun.arch.data.model"))) {
                    B.warn("64 bit Java is only compatible with 64 bit OpenOffice installations.  On Solaris and OSX try running Java with -d32.  On other platforms use a 32 bit Java installation.");
                    B.error("Link Error and your Java is 64 bit but perhaps your OpenOffice is not.  Try running Java in 32 bit mode if supported or use a 32 bit Java VM.", unsatisfiedLinkError);
                }
                B.error("Problem loading library:" + fileArray[n2].getAbsolutePath(), unsatisfiedLinkError);
            }
        }
        if (B.isDebugEnabled()) {
            B.debug("Native libraries: " + (fileArray == null ? 0 : fileArray.length) + " found, " + n + " loaded.");
        }
    }

    static {
        if (A) {
            OpenOfficeLibraryLoader.loadNativeLibraries();
        }
    }
}

