/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.mime.magic;

import com.docmosis.util.FileUtilities;
import com.docmosis.util.mime.MimeTypes;
import com.docmosis.util.mime.magic.MagicItem;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MagicRegistry {
    public static MagicItem FILE_MAGIC_DOC97 = MagicRegistry.item("doc", "D0 CF 11 E0 A1 B1 1A E1");
    public static MagicItem FILE_MAGIC_PDF = MagicRegistry.item("pdf", "25 50 44 46");
    public static MagicItem FILE_MAGIC_JPG = MagicRegistry.item("jpg", new String[]{"FF D8 FF E0 00 10 4A 46 49 46 00 01", "FF D8 FF DB", "FF D8 FF EE"});
    public static MagicItem FILE_MAGIC_PNG = MagicRegistry.item("png", "89 50 4E 47 0D 0A 1A 0A");
    public static MagicItem FILE_MAGIC_GIF = MagicRegistry.item("gif", new String[]{"47 49 46 38 37 61", "47 49 46 38 39 61"});
    public static MagicItem FILE_MAGIC_TIFF = MagicRegistry.item("tiff", new String[]{"49 49 2A 00", "4D 4D 00 2A"});
    private List B = new ArrayList();
    private int A = -1;

    public MagicRegistry() {
        this.B.add(FILE_MAGIC_DOC97);
        this.B.add(FILE_MAGIC_PDF);
        this.B.add(FILE_MAGIC_JPG);
        this.B.add(FILE_MAGIC_PNG);
        this.B.add(FILE_MAGIC_GIF);
        this.B.add(FILE_MAGIC_TIFF);
        for (int i = 0; i < this.B.size(); ++i) {
            MagicItem magicItem = (MagicItem)this.B.get(i);
            if (magicItem.longestByteArray() <= this.A) continue;
            this.A = magicItem.longestByteArray();
        }
    }

    public int getMaxMagicLength() {
        return this.A;
    }

    public String findMimeType(File file) throws IOException {
        String string = null;
        byte[] byArray = this.getFileHeaderBytes(file);
        for (int i = 0; i < this.B.size(); ++i) {
            MagicItem magicItem = (MagicItem)this.B.get(i);
            if (!magicItem.bytesMatch(byArray)) continue;
            string = magicItem.getMimeType();
            break;
        }
        return string;
    }

    public boolean hasSignature(File file, MagicItem magicItem) throws IOException {
        return magicItem.bytesMatch(FileUtilities.readPartial(file, magicItem.longestByteArray()));
    }

    private byte[] getFileHeaderBytes(File file) throws IOException {
        return FileUtilities.readPartial(file, this.A);
    }

    private static MagicItem item(String string, String string2) {
        return MagicRegistry.item(string, new String[]{string2});
    }

    private static MagicItem item(String string, String[] stringArray) {
        String string2 = MimeTypes.getByName("." + string);
        if (string2 == null) {
            throw new IllegalStateException("Cannot determine mime type for extension [." + string + "]");
        }
        return new MagicItem(string2, stringArray);
    }
}

