/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.mime;

import com.docmosis.util.DMProperties;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.mime.MimeTypes;
import com.docmosis.util.mime.magic.MagicItem;
import com.docmosis.util.mime.magic.MagicRegistry;
import com.docmosis.util.mime.zip.DocxZipEntryProcessor;
import com.docmosis.util.mime.zip.OdtZipEntryProcessor;
import com.docmosis.util.mime.zip.ZipEntryLineByLineProcessor;
import com.docmosis.util.mime.zip.ZipEntryProcessor;
import com.docmosis.util.mime.zip.ZipEntryProcessorFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;

public class MimeUtilities {
    private static ZipEntryProcessorFactory B = ZipEntryProcessorFactory.build();
    private static MagicRegistry A = new MagicRegistry();
    private static final int C = DMProperties.getInt("docmosis.mime.types.text.sampleSize", 4096);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMimeType(File file) throws IOException {
        String string = null;
        if (file.length() > 0L) {
            ZipInputStream zipInputStream = MimeUtilities.openZip(file);
            if (zipInputStream != null) {
                try {
                    string = MimeUtilities.determineTypeFromZipStream(zipInputStream);
                }
                finally {
                    FileUtilities.close(zipInputStream);
                }
            } else {
                string = MimeUtilities.determineTypeFromMagic(file);
                if (string == null) {
                    string = MimeUtilities.determineTypeFromTextTypes(file);
                }
            }
        }
        return string;
    }

    public static String getMimeType(String string) {
        if (string != null) {
            return MimeTypes.getByName(string);
        }
        return "application/octet-stream";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ZipInputStream openZip(File file) throws IOException {
        ZipInputStream zipInputStream = null;
        ZipInputStream zipInputStream2 = null;
        try {
            zipInputStream2 = new ZipInputStream(new FileInputStream(file));
            if (zipInputStream2.getNextEntry() != null) {
                FileUtilities.close(zipInputStream2);
                zipInputStream2 = null;
                zipInputStream = new ZipInputStream(new FileInputStream(file));
            }
        }
        catch (Throwable throwable) {
            FileUtilities.close(zipInputStream2);
            throw throwable;
        }
        FileUtilities.close(zipInputStream2);
        return zipInputStream;
    }

    private static String determineTypeFromTextTypes(File file) throws IOException {
        String string = null;
        char[] cArray = MimeUtilities.readChars(file, C);
        if (MimeUtilities.isTextSample(cArray)) {
            string = MimeTypes.getByName(".txt");
            if (MimeUtilities.isHtmlSample(cArray)) {
                string = MimeTypes.getByName(".html");
            } else if (MimeUtilities.isXmlSample(cArray)) {
                string = MimeUtilities.isFODT(cArray) ? MimeTypes.getByName(".odt") : MimeTypes.getByName(".xml");
            }
        }
        return string;
    }

    private static String determineTypeFromMagic(File file) throws IOException {
        String string = A.findMimeType(file);
        if (string == null && MimeUtilities.isRtfFormat(file)) {
            return MimeTypes.getByName(".rtf");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String determineTypeFromZipStream(ZipInputStream zipInputStream) throws ZipException, IOException {
        String string = null;
        ZipEntry zipEntry;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            List list = B.getProcessorsFor(zipEntry.getName());
            if (list == null) continue;
            boolean bl = false;
            for (int i = 0; i < list.size(); ++i) {
                ZipEntryProcessor zipEntryProcessor = (ZipEntryProcessor)list.get(i);
                if (!zipEntryProcessor.inspectsEntryContents()) continue;
                bl = true;
                break;
            }
            File file = null;
            try {
                if (bl) {
                    file = FileUtilities.createTempFile("dm_", "met");
                    FileUtilities.storeToFile(zipInputStream, file);
                }
                for (int i = 0; i < list.size(); ++i) {
                    ZipEntryProcessor zipEntryProcessor = (ZipEntryProcessor)list.get(i);
                    if (!zipEntryProcessor.matches(zipEntry.getName(), file)) continue;
                    string = zipEntryProcessor.getMimeType();
                    break;
                }
            }
            catch (Throwable throwable) {
                FileUtilities.delete(file);
                throw throwable;
            }
            FileUtilities.delete(file);
        }
        return string;
    }

    public static boolean isDocxFormat(InputStream inputStream) throws IOException {
        return MimeUtilities.isZipFormat(inputStream, new DocxZipEntryProcessor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOdtFormat(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            boolean bl = MimeUtilities.isOdtFormat(fileInputStream);
            return bl;
        }
        finally {
            FileUtilities.close(fileInputStream);
        }
    }

    public static boolean isOdtFormat(InputStream inputStream) throws IOException {
        return MimeUtilities.isZipFormat(inputStream, new OdtZipEntryProcessor());
    }

    public static boolean hasMagicSignature(File file, MagicItem magicItem) throws IOException {
        return A.hasSignature(file, magicItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isZipFormat(InputStream inputStream, ZipEntryLineByLineProcessor zipEntryLineByLineProcessor) throws IOException {
        boolean bl = false;
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(inputStream);
            block5: while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!zipEntry.getName().equals(zipEntryLineByLineProcessor.getEntryName())) continue;
                BufferedReader bufferedReader = null;
                try {
                    String string;
                    bufferedReader = new BufferedReader(new InputStreamReader(zipInputStream));
                    while ((string = bufferedReader.readLine()) != null) {
                        if (!zipEntryLineByLineProcessor.matches(string)) continue;
                        bl = true;
                        continue block5;
                    }
                }
                finally {
                    bufferedReader = null;
                }
            }
        }
        catch (Throwable throwable) {
            FileUtilities.close(zipInputStream);
            FileUtilities.close(inputStream);
            throw throwable;
        }
        FileUtilities.close(zipInputStream);
        FileUtilities.close(inputStream);
        return bl;
    }

    public static boolean isXmlFile(File file) throws IOException {
        char[] cArray = MimeUtilities.readChars(file, C);
        return MimeUtilities.isXmlSample(cArray);
    }

    public static boolean isHtmlFile(File file) throws IOException {
        char[] cArray = MimeUtilities.readChars(file, C);
        return MimeUtilities.isHtmlSample(cArray);
    }

    private static boolean isTextCharacter(char c) {
        return Character.isValidCodePoint(c) && (Character.isLetterOrDigit(c) || Character.isWhitespace(c) || c > ' ' && c < '\u007f');
    }

    public static boolean isTextFile(File file) throws IOException {
        char[] cArray = MimeUtilities.readChars(file, C);
        return MimeUtilities.isTextSample(cArray);
    }

    private static boolean isTextSample(char[] cArray) {
        int n;
        boolean bl = true;
        for (int i = n = MimeUtilities.skipBOM(cArray); i < cArray.length; ++i) {
            char c = cArray[i];
            if (MimeUtilities.isTextCharacter(c)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private static int skipBOM(char[] cArray) {
        int n = 0;
        char[][] cArrayArray = new char[][]{{'\ufffd', '\ufffd'}, {'\ufeff'}};
        for (int i = 0; i < cArrayArray.length; ++i) {
            char[] cArray2 = cArrayArray[i];
            if (cArray.length < cArray2.length) continue;
            boolean bl = true;
            for (int j = 0; j < cArray2.length; ++j) {
                if (cArray[j] == cArray2[j]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            n = cArray2.length;
            break;
        }
        return n;
    }

    private static boolean isHtmlSample(char[] cArray) {
        String string = new String(cArray).trim().toLowerCase();
        return string.startsWith("<!doctype html") || string.startsWith("<html");
    }

    private static boolean isXmlSample(char[] cArray) {
        int n;
        boolean bl = true;
        for (n = 0; n < cArray.length && Character.isWhitespace(cArray[n]); ++n) {
        }
        if (n < cArray.length) {
            if ('<' != cArray[n]) {
                bl = false;
            }
            ++n;
        }
        while (bl && n < cArray.length) {
            if (!MimeUtilities.isTextCharacter(cArray[n])) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char[] readChars(File file, int n) throws IOException {
        if (n < 1) {
            throw new IOException("maxLen must be greater than 0.  Was " + n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        try {
            for (int i = 0; i < n; ++i) {
                int n2 = ((Reader)inputStreamReader).read();
                if (n2 == -1) {
                    break;
                }
                stringBuffer.append((char)n2);
            }
        }
        finally {
            FileUtilities.close(inputStreamReader);
        }
        return stringBuffer.toString().toCharArray();
    }

    private static boolean isFODT(char[] cArray) {
        return new OdtZipEntryProcessor().matches(new String(cArray));
    }

    public static boolean isDocFormat(File file) throws IOException {
        return MimeUtilities.hasMagicSignature(file, MagicRegistry.FILE_MAGIC_DOC97);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRtfFormat(File file) throws IOException {
        if (!file.canRead()) {
            return false;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            boolean bl = MimeUtilities.isRtfFormat(fileInputStream);
            return bl;
        }
        finally {
            FileUtilities.close(fileInputStream);
        }
    }

    private static boolean isRtfFormat(InputStream inputStream) throws IOException {
        int n;
        while ((n = inputStream.read()) != -1 && Character.isWhitespace(n) && (char)n != '{') {
        }
        if ((char)n != '{') {
            return false;
        }
        while ((n = inputStream.read()) != -1 && Character.isWhitespace(n) && (char)n != '\\') {
        }
        if ((char)n != '\\') {
            return false;
        }
        try {
            if ((char)inputStream.read() == 'r' && (char)inputStream.read() == 't' && (char)inputStream.read() == 'f' && (char)inputStream.read() == '1') {
                return true;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return false;
    }
}

