/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.mime;

import com.docmosis.util.FileUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MimeTypes {
    private static final Logger B = LogManager.getLogger(MimeTypes.class);
    private static final Map A = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initTypes() {
        BufferedReader bufferedReader = null;
        InputStream inputStream = null;
        try {
            inputStream = MimeTypes.class.getResourceAsStream("mime.types");
            if (inputStream == null) {
                B.error("Unable to locate mime.types resource");
            } else {
                String string;
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string = bufferedReader.readLine()) != null) {
                    try {
                        MimeTypes.registerType(string);
                    }
                    catch (BadDescription badDescription) {
                        B.error(badDescription);
                    }
                }
                B.debug("Mime extensions mapped:" + A.size());
            }
        }
        catch (IOException iOException) {
            B.error("Unable to load mime types:", iOException);
        }
        finally {
            FileUtilities.close(bufferedReader);
            FileUtilities.close(inputStream);
        }
    }

    public static void registerType(String string) throws BadDescription {
        if (string == null || string.trim().isEmpty() || string.trim().startsWith("#")) {
            return;
        }
        String[] stringArray = string.split("\\s+");
        if (stringArray.length < 2) {
            throw new BadDescription("Invalid mime description:\"" + string + "\"");
        }
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        MimeTypes.registerType(stringArray[0], stringArray2);
    }

    public static void registerType(String string, String[] stringArray) throws BadDescription {
        if (string == null || "".equals(string.trim())) {
            throw new BadDescription("No mime string specified");
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new BadDescription("No file extensions specified");
        }
        string = string.toLowerCase();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = (String)A.get(string2 = string2.toLowerCase());
            if (string3 == null) {
                A.put(string2, string);
                continue;
            }
            if (string3.equals(string)) continue;
            throw new BadDescription("Cannot map extension \"" + string2 + "\" to \"" + string + "\"" + " because it is already mapped to \"" + string3 + "\"");
        }
    }

    public static String getByName(String string) {
        String string2;
        String string3;
        int n;
        String string4 = null;
        if (string != null && (n = string.lastIndexOf(46)) != -1 && n < string.length() && (string3 = (String)A.get(string2 = string.substring(n + 1))) != null) {
            string4 = string3;
        }
        return string4;
    }

    public static Set getExtensions(String string) {
        HashSet hashSet = new HashSet();
        for (Map.Entry entry : A.entrySet()) {
            if (!string.equals(entry.getValue())) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    public static Set getExtensions(Set set) {
        HashSet hashSet = new HashSet();
        for (Map.Entry entry : A.entrySet()) {
            if (!set.contains(entry.getValue())) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    public static void main(String[] stringArray) {
        System.out.println(MimeTypes.getByName("abc.odt"));
    }

    static {
        MimeTypes.initTypes();
    }

    public static class BadDescription
    extends Exception {
        private static final long A = 1L;

        public BadDescription(String string) {
            super(string);
        }
    }
}

