/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.logging;

import com.docmosis.util.DMProperties;
import com.docmosis.util.logging.JavaLogger;
import com.docmosis.util.logging.Log4JLogger;
import com.docmosis.util.logging.Logger;
import java.util.HashMap;

public class LogManager {
    private static final boolean B = DMProperties.getBoolean("docmosis.log.check.log4j");
    private static final boolean E = DMProperties.getBoolean("docmosis.log.check.appenders");
    private static final boolean A = DMProperties.getBoolean("docmosis.log.self.managed");
    private static final boolean D = LogManager.hasLog4J();
    private static final HashMap C = new HashMap();

    public static Logger getLogger(Class clazz) {
        Logger logger = null;
        logger = A ? LogManager.getManagedLogger(clazz) : LogManager.getNewLogger(clazz);
        return logger;
    }

    private static Logger getNewLogger(Class clazz) {
        if (B && D) {
            return new Log4JLogger(clazz);
        }
        return new JavaLogger(clazz.getName());
    }

    private static Logger getManagedLogger(Class clazz) {
        Logger logger = (Logger)C.get(clazz);
        if (logger == null) {
            logger = LogManager.getNewLogger(clazz);
            C.put(clazz, logger);
        }
        return logger;
    }

    private static boolean hasLog4J() {
        boolean bl;
        boolean bl2;
        block6: {
            bl2 = false;
            bl = false;
            try {
                if (!B) break block6;
                try {
                    Class.forName("org.apache.log4j.Category");
                    Log4JLogger log4JLogger = new Log4JLogger(LogManager.class);
                    bl2 = true;
                    if (!E) break block6;
                    if (!log4JLogger.hasAppenders()) {
                        LogManager.note("No Log4J appenders could be found.  Using Java logging.");
                        break block6;
                    }
                    bl = true;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    LogManager.note("Log4J not found in class path.  Using Java logging.");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LogManager.note("Log4J not found in class path.  Using Java logging.");
                }
            }
            catch (RuntimeException runtimeException) {
                System.err.println("Unable to configure LogManager");
                runtimeException.printStackTrace();
            }
        }
        return bl2 && (!E || bl);
    }

    private static void note(String string) {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(LogManager.class.getName());
        logger.fine(string);
    }
}

