/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.logging;

import com.docmosis.util.logging.Logger;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class JavaLogger
implements Logger {
    private final java.util.logging.Logger D;

    protected JavaLogger(String string) {
        this.D = java.util.logging.Logger.getLogger(string);
    }

    @Override
    public void trace(Object object) {
        this.log(Level.FINER, object);
    }

    @Override
    public void trace(Object object, Throwable throwable) {
        this.log(Level.FINER, object, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        if (this.D == null) {
            return false;
        }
        return this.D.isLoggable(Level.FINER);
    }

    @Override
    public void debug(Object object) {
        this.log(Level.FINE, object);
    }

    @Override
    public void debug(Object object, Throwable throwable) {
        this.log(Level.FINE, object, throwable);
    }

    @Override
    public boolean isDebugEnabled() {
        if (this.D == null) {
            return false;
        }
        return this.D.isLoggable(Level.FINE);
    }

    @Override
    public void info(Object object) {
        this.log(Level.INFO, object);
    }

    @Override
    public void info(Object object, Throwable throwable) {
        this.log(Level.INFO, object, throwable);
    }

    @Override
    public boolean isInfoEnabled() {
        if (this.D == null) {
            return false;
        }
        return this.D.isLoggable(Level.INFO);
    }

    @Override
    public void warn(Object object) {
        this.log(Level.WARNING, object);
    }

    @Override
    public void warn(Object object, Throwable throwable) {
        this.log(Level.WARNING, object, throwable);
    }

    @Override
    public void error(Object object) {
        this.log(Level.SEVERE, object);
    }

    @Override
    public void error(Object object, Throwable throwable) {
        this.log(Level.SEVERE, object, throwable);
    }

    @Override
    public void fatal(Object object) {
        this.log(Level.SEVERE, object);
    }

    @Override
    public void fatal(Object object, Throwable throwable) {
        this.log(Level.SEVERE, object, throwable);
    }

    private void log(Level level, Object object) {
        if (this.D == null) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, object == null ? "" : object.toString());
        logRecord.setSourceClassName(this.D.getName());
        logRecord.setLoggerName(this.D.getName());
        this.D.log(logRecord);
    }

    private void log(Level level, Object object, Throwable throwable) {
        if (this.D == null) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, object == null ? "" : object.toString());
        logRecord.setSourceClassName(this.D.getName());
        logRecord.setLoggerName(this.D.getName());
        logRecord.setThrown(throwable);
        this.D.log(logRecord);
    }
}

