/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.locale;

import com.docmosis.util.StringUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;

public class LocaleUtils {
    private static final Logger F = LogManager.getLogger(LocaleUtils.class);
    private static Locale[] J = LocaleUtils.getSortedLocales();
    private static final Map I = LocaleUtils.createLocaleLanguageAndCountryLookup(new _A(){

        @Override
        public String A(Locale locale) {
            return locale.getLanguage() + "," + locale.getCountry() + "," + locale.getVariant();
        }
    });
    private static final Map D = LocaleUtils.createLocaleLanguageAndCountryLookup(new _A(){

        @Override
        public String A(Locale locale) {
            return locale.toString();
        }
    });
    private static final Map H = LocaleUtils.createLocaleCountryLookup(new _A(){

        @Override
        public String A(Locale locale) {
            return locale.getCountry();
        }
    });
    private static final Map K = LocaleUtils.createLocaleCountryLookup(new _A(){

        @Override
        public String A(Locale locale) {
            try {
                return locale.getISO3Country();
            }
            catch (MissingResourceException missingResourceException) {
                return null;
            }
        }
    });
    private static final Map G = LocaleUtils.createLocaleCountryLookup(new _A(){

        @Override
        public String A(Locale locale) {
            return locale.getDisplayCountry();
        }
    });
    private static final Map C = LocaleUtils.createLocaleLanguageLookup(new _A(){

        @Override
        public String A(Locale locale) {
            return locale.getLanguage();
        }
    });
    private static final Map A = LocaleUtils.createLocaleLanguageLookup(new _A(){

        @Override
        public String A(Locale locale) {
            try {
                return locale.getISO3Language();
            }
            catch (MissingResourceException missingResourceException) {
                return null;
            }
        }
    });
    private static final Map B = LocaleUtils.createLocaleLanguageLookup(new _A(){

        @Override
        public String A(Locale locale) {
            return locale.getDisplayLanguage();
        }
    });
    private static Map[] E = new Map[]{H, K, G, C, A, B};

    private static Map createLocaleCountryLookup(_A _A2) {
        HashMap hashMap = new HashMap();
        LocaleUtils.installStandardCountries(_A2, hashMap);
        LocaleUtils.createLocaleLookup(_A2, hashMap);
        return hashMap;
    }

    private static Map createLocaleLanguageLookup(_A _A2) {
        HashMap hashMap = new HashMap();
        LocaleUtils.installStandardLanguages(_A2, hashMap);
        LocaleUtils.createLocaleLookup(_A2, hashMap);
        return hashMap;
    }

    private static Map createLocaleLanguageAndCountryLookup(_A _A2) {
        HashMap hashMap = new HashMap();
        LocaleUtils.installStandardCountries(_A2, hashMap);
        LocaleUtils.installStandardLanguages(_A2, hashMap);
        LocaleUtils.createLocaleLookup(_A2, hashMap);
        return hashMap;
    }

    private static void installStandardCountries(_A _A2, Map map) {
        LocaleUtils.addElement(Locale.FRANCE, _A2, map);
        LocaleUtils.addElement(Locale.GERMANY, _A2, map);
        LocaleUtils.addElement(Locale.ITALY, _A2, map);
        LocaleUtils.addElement(Locale.JAPAN, _A2, map);
        LocaleUtils.addElement(Locale.KOREA, _A2, map);
        LocaleUtils.addElement(Locale.CHINA, _A2, map);
        LocaleUtils.addElement(Locale.PRC, _A2, map);
        LocaleUtils.addElement(Locale.TAIWAN, _A2, map);
        LocaleUtils.addElement(Locale.UK, _A2, map);
        LocaleUtils.addElement(Locale.US, _A2, map);
        LocaleUtils.addElement(Locale.CANADA, _A2, map);
        LocaleUtils.addElement(Locale.CANADA_FRENCH, _A2, map);
    }

    private static void installStandardLanguages(_A _A2, Map map) {
        LocaleUtils.addElement(Locale.ENGLISH, _A2, map);
        LocaleUtils.addElement(Locale.FRENCH, _A2, map);
        LocaleUtils.addElement(Locale.GERMAN, _A2, map);
        LocaleUtils.addElement(Locale.ITALIAN, _A2, map);
        LocaleUtils.addElement(Locale.JAPANESE, _A2, map);
        LocaleUtils.addElement(Locale.KOREAN, _A2, map);
        LocaleUtils.addElement(Locale.CHINESE, _A2, map);
        LocaleUtils.addElement(Locale.SIMPLIFIED_CHINESE, _A2, map);
        LocaleUtils.addElement(Locale.TRADITIONAL_CHINESE, _A2, map);
    }

    private static Locale[] getSortedLocales() {
        Locale[] localeArray = NumberFormat.getAvailableLocales();
        List<Locale> list = Arrays.asList(localeArray);
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = object == null ? "" : object.toString();
                String string2 = object2 == null ? "" : object2.toString();
                return string.compareTo(string2);
            }
        });
        list.toArray(localeArray);
        return localeArray;
    }

    private static void createLocaleLookup(_A _A2, Map map) {
        Locale[] localeArray = J;
        if (localeArray != null) {
            for (int i = 0; i < localeArray.length; ++i) {
                LocaleUtils.addElement(localeArray[i], _A2, map);
            }
        }
    }

    private static void addElement(Locale locale, _A _A2, Map map) {
        try {
            String string;
            String string2 = _A2.A(locale);
            if (!StringUtilities.isEmpty(string2) && !map.containsKey(string = string2.toLowerCase())) {
                map.put(string, locale);
            }
        }
        catch (RuntimeException runtimeException) {
            F.warn("Error creating lookup", runtimeException);
        }
    }

    public static Locale localeStringToLocale(String string) throws UnknownLocaleException {
        boolean bl;
        Locale locale = null;
        if (!StringUtilities.isEmpty(string) && (locale = (bl = string.indexOf(44) != -1 || string.indexOf(95) != -1) ? LocaleUtils.lookupSpecific(string) : LocaleUtils.lookupByCountryOrLanguage(string)) == null) {
            throw new UnknownLocaleException(string);
        }
        return locale;
    }

    public static Locale lookupByCountryOrLanguage(String string) {
        String string2 = string.toLowerCase();
        Locale locale = null;
        for (int i = 0; i < E.length && (locale = (Locale)E[i].get(string2)) == null; ++i) {
        }
        return locale;
    }

    public static Locale lookupSpecific(String string) {
        Locale locale = null;
        if (!StringUtilities.isEmpty(string)) {
            if ((string = string.toLowerCase()).indexOf(95) != -1) {
                locale = (Locale)D.get(string);
            } else {
                int n = string.indexOf(44);
                if (n != -1) {
                    boolean bl;
                    boolean bl2 = bl = n == string.length() - 1 || string.indexOf(44, n + 1) == -1;
                    if (bl) {
                        string = string + ",";
                    }
                    if (string.startsWith(",") && string.endsWith(",")) {
                        String string2 = string.substring(1, string.length() - 1);
                        locale = (Locale)H.get(string2);
                    } else {
                        locale = (Locale)I.get(string);
                    }
                } else {
                    locale = (Locale)C.get(string);
                }
            }
        }
        return locale;
    }

    public static class UnknownLocaleException
    extends Exception {
        public UnknownLocaleException(String string) {
            super("Unknown locale:\"" + string + "\"");
        }
    }

    private static interface _A {
        public String A(Locale var1);
    }
}

