/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.image.exifdata;

import com.docmosis.util.image.EXIFOrientation;
import com.docmosis.util.image.exifdata.ImageMetaDataExtractor;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.drew.imaging.FileType;
import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifDirectoryBase;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class ImageMetaDataExtractorImpl
implements ImageMetaDataExtractor {
    private static final int A = 274;
    private static final Logger B = LogManager.getLogger(ImageMetaDataExtractorImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EXIFOrientation getExifOrientation(InputStream inputStream, int n) {
        EXIFOrientation eXIFOrientation = EXIFOrientation.NORMAL_HORIZONTAL;
        BufferedInputStream bufferedInputStream = null;
        try {
            if (inputStream != null) {
                EXIFOrientation eXIFOrientation2;
                ExifDirectoryBase exifDirectoryBase;
                Iterator iterator;
                bufferedInputStream = new BufferedInputStream(inputStream);
                bufferedInputStream.mark(44);
                FileType fileType = ImageMetaDataExtractorImpl.getFileFormat(n);
                Metadata metadata = ImageMetadataReader.readMetadata((InputStream)bufferedInputStream, (long)-1L, (FileType)fileType);
                if (metadata.containsDirectoryOfType(ExifDirectoryBase.class) && (iterator = metadata.getDirectoriesOfType(ExifDirectoryBase.class).iterator()).hasNext() && (exifDirectoryBase = (ExifDirectoryBase)iterator.next()).containsTag(274) && (eXIFOrientation2 = EXIFOrientation.forValue(exifDirectoryBase.getInteger(274))) != null) {
                    eXIFOrientation = eXIFOrientation2;
                }
            }
        }
        catch (IOException iOException) {
            B.warn("Unable to extract image metadata:" + iOException.getMessage());
        }
        catch (ImageProcessingException imageProcessingException) {
            B.warn("Unable to extract image metadata:" + imageProcessingException.getMessage());
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.reset();
                }
                catch (IOException iOException) {}
            }
        }
        return eXIFOrientation;
    }

    private static FileType getFileFormat(int n) {
        FileType fileType = FileType.Unknown;
        switch (n) {
            case 0: {
                fileType = FileType.Jpeg;
                break;
            }
            case 1: {
                fileType = FileType.Gif;
                break;
            }
            case 2: {
                fileType = FileType.Png;
                break;
            }
            case 3: {
                fileType = FileType.Bmp;
                break;
            }
            case 4: {
                fileType = FileType.Pcx;
                break;
            }
            case 10: {
                fileType = FileType.Psd;
                break;
            }
            case 11: {
                fileType = FileType.Tiff;
            }
        }
        return fileType;
    }
}

