/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.image;

import com.docmosis.util.DMProperties;
import com.docmosis.util.EngineVersion;
import com.docmosis.util.image.EXIFOrientation;
import com.docmosis.util.image.ImageInfoProvider;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class WebPAwareImageInfo
implements ImageInfoProvider {
    private static final Logger G = LogManager.getLogger(WebPAwareImageInfo.class);
    private static boolean C = false;
    private ImageInfoProvider F;
    private boolean D;
    private InputStream B;
    private int E;
    private int A;
    private final boolean H;

    public WebPAwareImageInfo(ImageInfoProvider imageInfoProvider, EngineVersion engineVersion) {
        this.F = imageInfoProvider;
        this.H = WebPAwareImageInfo.getWebPEnabledSetting(engineVersion);
    }

    @Override
    public void setInput(InputStream inputStream) {
        block5: {
            if (inputStream != null) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                try {
                    char[] cArray = new char[50];
                    bufferedInputStream.mark(cArray.length);
                    int n = new InputStreamReader((InputStream)bufferedInputStream, "UTF-8").read(cArray);
                    bufferedInputStream.reset();
                    this.D = n > 0 ? this.looksLikeWebP(new String(cArray, 0, n)) : false;
                    if (this.D) {
                        this.B = bufferedInputStream;
                        break block5;
                    }
                    this.F.setInput(bufferedInputStream);
                }
                catch (IOException iOException) {
                    G.warn("Unable to restore image stream", iOException);
                }
            } else {
                this.D = false;
            }
        }
    }

    @Override
    public boolean check() throws IOException {
        if (this.D) {
            return this.readWebP();
        }
        return this.F.check();
    }

    @Override
    public boolean allowed() {
        if (this.D) {
            return this.H;
        }
        return this.F.allowed();
    }

    @Override
    public int getWidth() {
        return this.D ? this.E : this.F.getWidth();
    }

    @Override
    public int getHeight() {
        return this.D ? this.A : this.F.getHeight();
    }

    private boolean looksLikeWebP(String string) {
        return string.toLowerCase().matches("(riff[\\s\\S]+webp[\\s\\S]+)");
    }

    private boolean readWebP() throws IOException {
        Integer n = null;
        Integer n2 = null;
        if (this.B != null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.B);
            byte[] byArray = new byte[30];
            bufferedInputStream.mark(byArray.length);
            bufferedInputStream.read(byArray, 0, 30);
            bufferedInputStream.reset();
            this.B = bufferedInputStream;
            if (byArray[15] == 32) {
                n = WebPAwareImageInfo.get16bit(byArray, 26) & 0x3FFF;
                n2 = WebPAwareImageInfo.get16bit(byArray, 28) & 0x3FFF;
            } else if (byArray[15] == 76) {
                int n3 = WebPAwareImageInfo.get16bit(byArray, 21);
                n = 1 + (n3 & 0x3FFF);
                int n4 = (n3 & 0xC000) >> 14;
                n2 = 1 + ((WebPAwareImageInfo.get16bit(byArray, 23) & 0xFFF) << 2 | n4);
            } else if (byArray[15] == 88) {
                n = 1 + WebPAwareImageInfo.get24bit(byArray, 24);
                n2 = 1 + WebPAwareImageInfo.get24bit(byArray, 27);
            }
        }
        if (n == null) {
            n = 1;
        }
        if (n2 == null) {
            n2 = 1;
        }
        this.E = n;
        this.A = n2;
        return true;
    }

    private static int get16bit(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    private static int get24bit(byte[] byArray, int n) {
        return WebPAwareImageInfo.get16bit(byArray, n) | (byArray[n + 2] & 0xFF) << 16;
    }

    private static boolean getWebPEnabledSetting(EngineVersion engineVersion) {
        boolean bl = false;
        String string = DMProperties.getString("docmosis.imageInfo.webp.enabled", "LO");
        if (string.equalsIgnoreCase("LO")) {
            try {
                if (engineVersion.isLibreOffice() && engineVersion.isVersionAtLeast("7.5.7")) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                G.warn("Unable to determine engine type", exception);
            }
        } else if (Boolean.valueOf(string).booleanValue()) {
            bl = true;
        }
        if (!C) {
            G.info("webp image format " + (bl ? "enabled" : "disabled"));
            C = true;
        } else if (G.isDebugEnabled()) {
            G.debug("webp image format " + (bl ? "enabled" : "disabled"));
        }
        return bl;
    }

    @Override
    public boolean checkExifMetadata() throws IOException {
        if (this.D) {
            return false;
        }
        return this.F.checkExifMetadata();
    }

    @Override
    public EXIFOrientation getOrientation() {
        if (this.D) {
            return EXIFOrientation.NORMAL_HORIZONTAL;
        }
        return this.F.getOrientation();
    }

    @Override
    public String getFormatName() {
        if (this.D) {
            return "webp";
        }
        return this.F.getFormatName();
    }
}

