/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.image;

import com.docmosis.util.DMProperties;
import com.docmosis.util.image.EXIFOrientation;
import com.docmosis.util.image.ImageInfoProvider;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class SvgAwareImageInfo
implements ImageInfoProvider {
    private static final Logger K = LogManager.getLogger(SvgAwareImageInfo.class);
    private static final String M = "[\t\n\u000b\f\r \u0085\u00a0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u2028\u2029\u202f\u205f\u3000]";
    private static final Pattern L = Pattern.compile("^[\t\n\u000b\f\r \u0085\u00a0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u2028\u2029\u202f\u205f\u3000]*\\<");
    static final String PROP_MOSTLY_TEXT_CHECK_ENABLED = "docmosis.imageInfo.svg.mostlyText.enabled";
    static final String PROP_MOSTLY_TEXT_CHECK_THRESHOLD = "docmosis.imageInfo.svg.mostlyText.pctThreshold";
    private ImageInfoProvider N;
    private boolean J;
    private InputStream O;
    private int I;
    private int P;

    public SvgAwareImageInfo(ImageInfoProvider imageInfoProvider) {
        this.N = imageInfoProvider;
    }

    @Override
    public void setInput(InputStream inputStream) {
        block5: {
            if (inputStream != null) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                try {
                    char[] cArray = new char[2048];
                    bufferedInputStream.mark(cArray.length);
                    int n = new InputStreamReader((InputStream)bufferedInputStream, "UTF-8").read(cArray);
                    bufferedInputStream.reset();
                    this.J = n > 0 ? this.looksLikeSvg(new String(cArray, 0, n)) : false;
                    if (this.J) {
                        this.O = bufferedInputStream;
                        break block5;
                    }
                    this.N.setInput(bufferedInputStream);
                }
                catch (IOException iOException) {
                    K.warn("Unable to restore image stream", iOException);
                }
            } else {
                this.J = false;
            }
        }
    }

    @Override
    public boolean check() throws IOException {
        if (this.J) {
            return this.readSvg();
        }
        return this.N.check();
    }

    @Override
    public boolean allowed() {
        if (this.J) {
            return true;
        }
        return this.N.allowed();
    }

    @Override
    public int getWidth() {
        return this.J ? this.I : this.N.getWidth();
    }

    @Override
    public int getHeight() {
        return this.J ? this.P : this.N.getHeight();
    }

    boolean looksLikeSvg(String string) {
        boolean bl;
        boolean bl2 = bl = string.toLowerCase().indexOf("<svg") != -1;
        if (bl) {
            bl = SvgAwareImageInfo.validXmlStart(string);
        }
        if (bl) {
            boolean bl3 = SvgAwareImageInfo.mostlyTextCheckEnabled();
            bl = bl3 ? SvgAwareImageInfo.mostlyText(string) : true;
        }
        return bl;
    }

    static boolean mostlyTextCheckEnabled() {
        return DMProperties.getBoolean(PROP_MOSTLY_TEXT_CHECK_ENABLED, true);
    }

    static boolean validXmlStart(String string) {
        return L.matcher(string).find();
    }

    static boolean mostlyText(String string) {
        float f = (float)DMProperties.getDouble(PROP_MOSTLY_TEXT_CHECK_THRESHOLD, 0.6);
        float f2 = SvgAwareImageInfo.getTextPct(string);
        return f2 >= f;
    }

    static float getTextPct(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '<' && c != '>' && c != '/' && c != '\"' && M.indexOf(c) == -1) continue;
            ++n;
        }
        return (float)n / (float)n2;
    }

    private boolean readSvg() throws IOException {
        try {
            Object object;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (DMProperties.getBoolean("docmosis.data.xml.blockExternalEntities", true)) {
                documentBuilder.setEntityResolver(new _A());
            }
            Document document = documentBuilder.parse(new InputSource(this.O));
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getChildNodes();
            int n = nodeList.getLength();
            Node node = null;
            for (int i = 0; i < n; ++i) {
                object = nodeList.item(i);
                if (!object.getNodeName().equals("svg")) continue;
                node = object;
                break;
            }
            Integer n2 = null;
            object = null;
            if (node != null && node.getAttributes() != null) {
                String string;
                if (node.getAttributes().getNamedItem("width") != null) {
                    string = node.getAttributes().getNamedItem("width").getNodeValue().toLowerCase().trim();
                    if (string.endsWith("px")) {
                        string = string.substring(0, string.length() - 2);
                    }
                    try {
                        n2 = Double.valueOf(string).intValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (node.getAttributes().getNamedItem("height") != null) {
                    string = node.getAttributes().getNamedItem("height").getNodeValue().toLowerCase().trim();
                    if (string.endsWith("px")) {
                        string = string.substring(0, string.length() - 2);
                    }
                    try {
                        object = Double.valueOf(string).intValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (n2 == null || object == null) {
                    String[] stringArray;
                    string = null;
                    Node node2 = node.getAttributes().getNamedItem("viewBox");
                    if (node2 != null) {
                        string = node2.getTextContent();
                    }
                    if (string != null && (stringArray = string.split("\\s+")).length == 4) {
                        String string2;
                        if (n2 == null) {
                            string2 = stringArray[2].toLowerCase().trim();
                            if (string2.endsWith("px")) {
                                string2 = string2.substring(0, string2.length() - 2);
                            }
                            try {
                                n2 = Double.valueOf(string2).intValue();
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (object == null) {
                            string2 = stringArray[3].toLowerCase().trim();
                            if (string2.endsWith("px")) {
                                string2 = string2.substring(0, string2.length() - 2);
                            }
                            try {
                                object = Double.valueOf(string2).intValue();
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            if (n2 == null) {
                n2 = 1;
            }
            if (object == null) {
                object = 1;
            }
            this.I = n2;
            this.P = (Integer)object;
            return true;
        }
        catch (Exception exception) {
            K.warn("Unable to read image details", exception);
            throw new IOException("Error reading svg image:" + exception.getMessage());
        }
    }

    @Override
    public boolean checkExifMetadata() throws IOException {
        if (this.J) {
            return false;
        }
        return this.N.checkExifMetadata();
    }

    @Override
    public EXIFOrientation getOrientation() {
        if (this.J) {
            return EXIFOrientation.NORMAL_HORIZONTAL;
        }
        return this.N.getOrientation();
    }

    @Override
    public String getFormatName() {
        if (this.J) {
            return "svg";
        }
        return this.N.getFormatName();
    }

    private static class _A
    implements EntityResolver {
        private _A() {
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            K.warn("XML external entity resolution ignored:[" + string + "],[" + string2 + "]");
            InputSource inputSource = new InputSource(new ByteArrayInputStream("".getBytes()));
            return inputSource;
        }
    }
}

