/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.image;

import com.docmosis.util.image.EXIFOrientation;
import com.docmosis.util.image.ImageInfoProvider;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class PdfAwareImageInfo
implements ImageInfoProvider {
    private static final Logger T = LogManager.getLogger(PdfAwareImageInfo.class);
    private ImageInfoProvider S;
    private boolean U;
    private int R;
    private int Q;

    public PdfAwareImageInfo(ImageInfoProvider imageInfoProvider) {
        this.S = imageInfoProvider;
    }

    @Override
    public void setInput(InputStream inputStream) {
        if (inputStream != null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            try {
                char[] cArray = new char[1024];
                bufferedInputStream.mark(cArray.length);
                int n = new InputStreamReader((InputStream)bufferedInputStream, "UTF-8").read(cArray);
                bufferedInputStream.reset();
                this.U = n > 0 ? this.looksLikePdf(new String(cArray, 0, n)) : false;
                if (!this.U) {
                    this.S.setInput(bufferedInputStream);
                }
            }
            catch (IOException iOException) {
                T.warn("Unable to restore image stream", iOException);
            }
        } else {
            this.U = false;
        }
    }

    @Override
    public boolean check() throws IOException {
        if (this.U) {
            return this.readPdf();
        }
        return this.S.check();
    }

    @Override
    public boolean allowed() {
        if (this.U) {
            return true;
        }
        return this.S.allowed();
    }

    @Override
    public int getWidth() {
        return this.U ? this.R : this.S.getWidth();
    }

    @Override
    public int getHeight() {
        return this.U ? this.Q : this.S.getHeight();
    }

    private boolean looksLikePdf(String string) {
        return string.toLowerCase().indexOf("%pdf") != -1;
    }

    private boolean readPdf() throws IOException {
        this.R = this.Q = Integer.valueOf(1).intValue();
        return true;
    }

    @Override
    public boolean checkExifMetadata() throws IOException {
        if (this.U) {
            return false;
        }
        return this.S.checkExifMetadata();
    }

    @Override
    public EXIFOrientation getOrientation() {
        if (this.U) {
            return EXIFOrientation.NORMAL_HORIZONTAL;
        }
        return this.S.getOrientation();
    }

    @Override
    public String getFormatName() {
        if (this.U) {
            return "pdf";
        }
        return this.S.getFormatName();
    }
}

