/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util.image;

import com.docmosis.util.image.EXIFOrientation;
import com.docmosis.util.image.ImageInfoProvider;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MetafileImageInfo
implements ImageInfoProvider {
    private static final Logger m = LogManager.getLogger(MetafileImageInfo.class);
    private InputStream p;
    private ImageInfoProvider o;
    private boolean l = false;
    private int k;
    private int q;
    private static final int n = 1;
    private static final String s = " EMF";
    private static final long r = Long.parseLong("9AC6CDD7", 16);

    public MetafileImageInfo(ImageInfoProvider imageInfoProvider) {
        this.o = imageInfoProvider;
    }

    @Override
    public void setInput(InputStream inputStream) {
        this.p = inputStream;
    }

    @Override
    public boolean check() throws IOException {
        if (this.p == null) {
            return false;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.p);
        bufferedInputStream.mark(44);
        byte[] byArray = new byte[44];
        int n = bufferedInputStream.read(byArray, 0, 44);
        if (n < 16) {
            bufferedInputStream.reset();
            this.o.setInput(bufferedInputStream);
            return this.o.check();
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.mark();
        long l = MetafileImageInfo.getUnsignedIntLE(byteBuffer);
        byteBuffer.reset();
        try {
            if (l == 1L) {
                this.checkEMF(byteBuffer);
                return true;
            }
            if (l == r) {
                this.checkWMF(byteBuffer);
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            m.warn(illegalArgumentException.getMessage());
        }
        bufferedInputStream.reset();
        this.o.setInput(bufferedInputStream);
        return this.o.check();
    }

    @Override
    public boolean allowed() {
        if (this.l) {
            return true;
        }
        return this.o.allowed();
    }

    @Override
    public int getWidth() {
        return this.l ? this.k : this.o.getWidth();
    }

    @Override
    public int getHeight() {
        return this.l ? this.q : this.o.getHeight();
    }

    private void checkEMF(ByteBuffer byteBuffer) throws IllegalArgumentException {
        byteBuffer.getInt();
        byteBuffer.getInt();
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        int n4 = byteBuffer.getInt();
        byteBuffer.getInt();
        byteBuffer.getInt();
        byteBuffer.getInt();
        byteBuffer.getInt();
        byte[] byArray = new byte[4];
        byteBuffer.get(byArray);
        String string = new String(byArray);
        if (!s.equals(string)) {
            throw new IllegalArgumentException("EMF image failed signature check");
        }
        this.k = n3 - n;
        this.q = n4 - n2;
        this.l = true;
    }

    private static long getUnsignedIntLE(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[4];
        byteBuffer.get(byArray);
        return MetafileImageInfo.getUnsignedIntLE(byArray);
    }

    static long getUnsignedIntLE(byte[] byArray) {
        long l = byArray[0] & 0xFF;
        long l2 = byArray[1] & 0xFF;
        long l3 = byArray[2] & 0xFF;
        long l4 = byArray[3] & 0xFF;
        return (l4 << 24) + (l3 << 16) + (l2 << 8) + l;
    }

    private void checkWMF(ByteBuffer byteBuffer) throws IllegalArgumentException {
        short s = byteBuffer.getShort();
        short s2 = byteBuffer.getShort();
        byteBuffer.getShort();
        short s3 = byteBuffer.getShort();
        short s4 = byteBuffer.getShort();
        short s5 = byteBuffer.getShort();
        short s6 = byteBuffer.getShort();
        short s7 = byteBuffer.getShort();
        byteBuffer.getInt();
        short s8 = byteBuffer.getShort();
        int n = 0;
        n ^= s;
        n ^= s2;
        n ^= s3;
        n ^= s4;
        n ^= s5;
        n ^= s6;
        if (s8 != (n ^= s7)) {
            throw new IllegalArgumentException("WMF image failed checksum");
        }
        this.k = s5 - s3;
        this.q = s6 - s4;
        this.l = true;
    }

    @Override
    public boolean checkExifMetadata() throws IOException {
        if (this.l) {
            return false;
        }
        return this.o.checkExifMetadata();
    }

    @Override
    public EXIFOrientation getOrientation() {
        if (this.l) {
            return EXIFOrientation.NORMAL_HORIZONTAL;
        }
        return this.o.getOrientation();
    }

    @Override
    public String getFormatName() {
        if (this.l) {
            return "emf";
        }
        return this.o.getFormatName();
    }
}

