/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util;

import com.docmosis.util.StringUtilities;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlUtilities {
    public static String extractHost(String string) throws MalformedURLException {
        URL uRL = new URL(string);
        return uRL.getHost();
    }

    private static String createRegexFromString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '*': {
                    stringBuilder.append(".*");
                    continue block6;
                }
                case '?': {
                    stringBuilder.append("\\?");
                    continue block6;
                }
                case '.': {
                    stringBuilder.append("\\.");
                    continue block6;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block6;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static boolean matchesWildcardPrefix(String string, String string2) {
        String string3 = UrlUtilities.createRegexFromString(string2).concat(".*");
        return string.matches(string3);
    }

    public static void validateWildcardPrefix(String string) throws InvalidSpecificationException {
        String string2;
        try {
            string2 = UrlUtilities.extractHost(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new InvalidSpecificationException("Invalid url specified [" + string + "].  Must be a url");
        }
        if (!StringUtilities.isEmpty(string2) && string2.indexOf(42) != -1) {
            String[] stringArray = string2.split("\\.");
            if (stringArray.length > 2) {
                int n;
                for (n = stringArray.length - 1; n >= stringArray.length - 2; --n) {
                    if (!stringArray[n].isEmpty() && !stringArray[n].contains("*")) continue;
                    throw new InvalidSpecificationException("Invalid wildcard format for: \"" + string + "\". Must have at least 2 static elements at end of host, eg https://*.a.b");
                }
                for (n = 0; n < stringArray.length - 2; ++n) {
                    if (!stringArray[n].isEmpty()) continue;
                    throw new InvalidSpecificationException("Invalid wildcard format for: \"" + string + "\". No elements in host can be empty, eg https://*.a.b");
                }
            } else {
                throw new InvalidSpecificationException("Invalid wildcard format for: \"" + string + "\". Must have at least 2 static elements at end of host, eg https://*.a.b");
            }
        }
    }

    public static boolean validateSimpleURL(String string, String[] stringArray, String[] stringArray2) {
        if (!StringUtilities.hasValue(string)) {
            return false;
        }
        String string2 = "([a-zA-Z]*://)(www.)?[a-zA-Z0-9][a-zA-Z0-9&/\\-_:\\.]*";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String string3 = string.substring(0, string.indexOf(":"));
        boolean bl = false;
        for (String string4 : stringArray) {
            if (!string3.equals(string4)) continue;
            bl = true;
        }
        if (!bl) {
            return false;
        }
        try {
            String string5 = UrlUtilities.extractHost(string);
            int n = 0;
            for (String string6 : stringArray2) {
                if (!string5.equals(string6) && !string5.endsWith("." + string6)) continue;
                n = 1;
            }
            if (n == 0) {
                return false;
            }
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    public static class InvalidSpecificationException
    extends Exception {
        public InvalidSpecificationException(String string) {
            super(string);
        }
    }
}

