/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.util;

import com.docmosis.util.Base64Helper;
import com.docmosis.util.EncryptionUtilities;
import com.docmosis.util.StringUtilities;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Collections;

public class TwoWayPasswordEncrypter {
    public static String encrypt(String string, String string2) throws InvalidParameterException {
        if (!StringUtilities.hasValue(string)) {
            throw new InvalidParameterException("No value for password");
        }
        if (!StringUtilities.hasValue(string2)) {
            throw new InvalidParameterException("No value for secretKey");
        }
        String string3 = EncryptionUtilities.encryptAES(string, TwoWayPasswordEncrypter.decodeSecretKey(string2));
        int n = (int)Math.floor((double)string3.length() / 2.0);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TwoWayPasswordEncrypter.generateRandomAlphaNumericString(4));
        stringBuilder.append(string3.substring(0, n));
        stringBuilder.append(TwoWayPasswordEncrypter.generateRandomAlphaNumericString(2));
        stringBuilder.append(string3.substring(n));
        stringBuilder.append(TwoWayPasswordEncrypter.generateRandomAlphaNumericString(3));
        return EncryptionUtilities.encryptAES(stringBuilder.toString(), TwoWayPasswordEncrypter.decodeSecretKey(string2));
    }

    public static String decrypt(String string, String string2) throws InvalidParameterException {
        if (!StringUtilities.hasValue(string)) {
            throw new InvalidParameterException("No value for encrypted password");
        }
        if (!StringUtilities.hasValue(string2)) {
            throw new InvalidParameterException("No value for secretKey");
        }
        String string3 = EncryptionUtilities.decryptAES(string, TwoWayPasswordEncrypter.decodeSecretKey(string2));
        String string4 = string3.substring(4, string3.length() - 3);
        int n = (int)Math.floor((double)string4.length() / 2.0);
        string4 = string4.substring(0, n - 1) + string4.substring(n + 1);
        return EncryptionUtilities.decryptAES(string4, TwoWayPasswordEncrypter.decodeSecretKey(string2));
    }

    protected static String decodeSecretKey(String string) {
        String string2 = new String(Base64Helper.toBytes(string));
        string2 = string2.substring(10, string2.length() - 11);
        int n = (int)Math.floor((double)string2.length() / 2.0);
        string2 = string2.substring(0, n - 2) + string2.substring(n + 2);
        char[] cArray = string2.toCharArray();
        Collections.reverse(Arrays.asList(new char[][]{cArray}));
        String string3 = new String(cArray);
        return string3;
    }

    protected static String encodeSecretKey(String string) {
        int n = (int)Math.floor((double)string.length() / 2.0);
        char[] cArray = string.toCharArray();
        Collections.reverse(Arrays.asList(new char[][]{cArray}));
        String string2 = new String(cArray);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TwoWayPasswordEncrypter.generateRandomAlphaNumericString(10));
        stringBuilder.append(string2.substring(0, n));
        stringBuilder.append(TwoWayPasswordEncrypter.generateRandomAlphaNumericString(4));
        stringBuilder.append(string2.substring(n));
        stringBuilder.append(TwoWayPasswordEncrypter.generateRandomAlphaNumericString(11));
        return Base64Helper.toBase64(stringBuilder.toString().getBytes());
    }

    private static String generateRandomAlphaNumericString(int n) {
        String string = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            int n2 = (int)Math.floor(Math.random() * (double)string.length());
            string2 = string2 + string.substring(n2, n2 + 1);
        }
        return string2;
    }
}

